% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rm_number.R
\name{rm_number}
\alias{as_numeric}
\alias{as_numeric2}
\alias{ex_number}
\alias{rm_number}
\title{Remove/Replace/Extract Numbers}
\usage{
rm_number(text.var, trim = !extract, clean = TRUE, pattern = "@rm_number",
  replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

as_numeric(x)

as_numeric2(x)

ex_number(text.var, trim = !extract, clean = TRUE, pattern = "@rm_number",
  replacement = "", extract = TRUE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_number} uses the
\code{rm_number} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the numbers are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{x}{a character vector to convert to a numeric vector.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
\code{rm_number} - Returns a character string with number removed.

\code{as_numeric} - Returns a list of vectors of numbers.

\code{as_numeric2} - Returns an unlisted vector of numbers.
}
\description{
\code{rm_number} - Remove/replace/extract number from a string (works on
numbers with commas, decimals and negatives).

\code{as_numeric} - A wrapper for \code{as.numeric(gsub(",", "", x))}, which
removes commas and converts a list of vectors of strings to numeric.  If the
string cannot be converted to numeric \code{NA} is returned.

\code{as_numeric2} - A convenience function for \code{as_numeric} that
unlists and returns a vector rather than a list.
}
\examples{
x <- c("-2 is an integer.  -4.3 and 3.33 are not.",
    "123,456 is 0 alot -123456 more than -.2", "and 3456789123 fg for 345.",
    "fg 12,345 23 .44 or 18.", "don't remove this 444,44", "hello world -.q")

rm_number(x)
ex_number(x)

##Convert to numeric
as_numeric(ex_number(x))   # retain list
as_numeric2(ex_number(x))  # unlist
}
\references{
The number regular expression was created by Jason Gray.
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_.functions: \code{\link{as_time}},
  \code{\link{as_time2}}, \code{\link{ex_time}},
  \code{\link{ex_transcript_time}}, \code{\link{rm_time}},
  \code{\link{rm_transcript_time}};
  \code{\link{ex_abbreviation}},
  \code{\link{rm_abbreviation}}; \code{\link{ex_angle}},
  \code{\link{ex_bracket}},
  \code{\link{ex_bracket_multiple}},
  \code{\link{ex_curly}}, \code{\link{ex_round}},
  \code{\link{ex_square}}, \code{\link{rm_angle}},
  \code{\link{rm_bracket}},
  \code{\link{rm_bracket_multiple}},
  \code{\link{rm_curly}}, \code{\link{rm_round}},
  \code{\link{rm_square}}; \code{\link{ex_between}},
  \code{\link{ex_between_multiple}},
  \code{\link{rm_between}},
  \code{\link{rm_between_multiple}};
  \code{\link{ex_caps_phrase}},
  \code{\link{rm_caps_phrase}}; \code{\link{ex_caps}},
  \code{\link{rm_caps}}; \code{\link{ex_citation_tex}},
  \code{\link{rm_citation_tex}}; \code{\link{ex_citation}},
  \code{\link{rm_citation}};
  \code{\link{ex_city_state_zip}},
  \code{\link{rm_city_state_zip}};
  \code{\link{ex_city_state}}, \code{\link{rm_city_state}};
  \code{\link{ex_date}}, \code{\link{rm_date}};
  \code{\link{ex_default}}, \code{\link{rm_default}};
  \code{\link{ex_dollar}}, \code{\link{rm_dollar}};
  \code{\link{ex_email}}, \code{\link{rm_email}};
  \code{\link{ex_emoticon}}, \code{\link{rm_emoticon}};
  \code{\link{ex_endmark}}, \code{\link{rm_endmark}};
  \code{\link{ex_hash}}, \code{\link{rm_hash}};
  \code{\link{ex_nchar_words}},
  \code{\link{rm_nchar_words}}; \code{\link{ex_non_ascii}},
  \code{\link{rm_non_ascii}}; \code{\link{ex_non_words}},
  \code{\link{rm_non_words}}; \code{\link{ex_percent}},
  \code{\link{rm_percent}}; \code{\link{ex_phone}},
  \code{\link{rm_phone}}; \code{\link{ex_postal_code}},
  \code{\link{rm_postal_code}};
  \code{\link{ex_repeated_characters}},
  \code{\link{rm_repeated_characters}};
  \code{\link{ex_repeated_phrases}},
  \code{\link{rm_repeated_phrases}};
  \code{\link{ex_repeated_words}},
  \code{\link{rm_repeated_words}}; \code{\link{ex_tag}},
  \code{\link{rm_tag}}; \code{\link{ex_title_name}},
  \code{\link{rm_title_name}};
  \code{\link{ex_twitter_url}}, \code{\link{ex_url}},
  \code{\link{rm_twitter_url}}, \code{\link{rm_url}};
  \code{\link{ex_white}}, \code{\link{ex_white_bracket}},
  \code{\link{ex_white_colon}},
  \code{\link{ex_white_comma}},
  \code{\link{ex_white_endmark}},
  \code{\link{ex_white_lead}},
  \code{\link{ex_white_lead_trail}},
  \code{\link{ex_white_multiple}},
  \code{\link{ex_white_punctuation}},
  \code{\link{ex_white_trail}}, \code{\link{rm_white}},
  \code{\link{rm_white_bracket}},
  \code{\link{rm_white_colon}},
  \code{\link{rm_white_comma}},
  \code{\link{rm_white_endmark}},
  \code{\link{rm_white_lead}},
  \code{\link{rm_white_lead_trail}},
  \code{\link{rm_white_multiple}},
  \code{\link{rm_white_punctuation}},
  \code{\link{rm_white_trail}}; \code{\link{ex_zip}},
  \code{\link{rm_zip}}
}
\keyword{number}

