% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.0.R
\name{sqdft}
\alias{sqdft}
\title{Spline Quantile Discrete Fourier Transform (SQDFT) of Time Series}
\usage{
sqdft(
  y,
  tau,
  spar = NULL,
  d = 1,
  weighted = FALSE,
  method = c("AIC", "BIC", "SIC"),
  ztol = 1e-05,
  n.cores = 1,
  cl = NULL
)
}
\arguments{
\item{y}{vector or matrix of time series (if matrix, \code{nrow(y)} = length of time series)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{spar}{smoothing parameter: if \code{spar=NULL}, smoothing parameter is selected by \code{method}}

\item{d}{subsampling rate of quantile levels (default = 1)}

\item{weighted}{if \code{TRUE}, penalty function is weighted (default = \code{FALSE})}

\item{method}{crietrion for smoothing parameter selection when \code{spar=NULL} (\code{"AIC"}, \code{"BIC"}, or \code{"SIC"})}

\item{ztol}{zero tolerance parameter used to determine the effective dimensionality of the fit}

\item{n.cores}{number of cores for parallel computing (default = 1)}

\item{cl}{pre-existing cluster for repeated parallel computing (default = \code{NULL})}
}
\value{
A list with the following elements:
  \item{coefficients}{matrix of regression coefficients}
  \item{qdft}{matrix or array of the spline quantile discrete Fourier transform of \code{y}}
  \item{crit}{criteria for smoothing parameter selection: (AIC,BIC,SIC)}
}
\description{
This function computes spline quantile discrete Fourier transform (SQDFT) for univariate or multivariate time series
through trigonometric spline quantile regression.
}
\examples{
y <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y.sqdft <- sqdft(y,tau,spar=NULL,d=4,metho="AIC")$qdft
}
