% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.0.R
\name{tsqr.fit}
\alias{tsqr.fit}
\title{Trigonometric Spline Quantile Regression (TSQR) of Time Series}
\usage{
tsqr.fit(
  y,
  f0,
  tau,
  spar = 1,
  d = 1,
  weighted = FALSE,
  mthreads = TRUE,
  prepared = TRUE,
  ztol = 1e-05
)
}
\arguments{
\item{y}{time series}

\item{f0}{frequency in [0,1)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{spar}{smoothing parameter}

\item{d}{subsampling rate of quantile levels (default = 1)}

\item{weighted}{if \code{TRUE}, penalty function is weighted (default = \code{FALSE})}

\item{mthreads}{if \code{FALSE}, set \code{RhpcBLASctl::blas_set_num_threads(1)} (default = \code{TRUE})}

\item{prepared}{if \code{TRUE}, intercept is removed and coef of cosine is doubled when \code{f0 = 0.5}}

\item{ztol}{zero tolerance parameter used to determine the effective dimensionality of the fit}
}
\value{
object of \code{sqr.fit()} (coefficients in \code{$coef})
}
\description{
This function computes trigonometric spline quantile regression (TSQR) for univariate time series at a single frequency.
}
\examples{
y <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
fit <- tqr.fit(y,f0=0.1,tau=tau)
fit.sqr <- tsqr.fit(y,f0=0.1,tau=tau,spar=1,d=4)
plot(tau,fit$coef[1,],type='p',xlab='QUANTILE LEVEL',ylab='TQR COEF')
lines(tau,fit.sqr$coef[1,],type='l')
}
