% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.1.R
\name{qdft2qser}
\alias{qdft2qser}
\title{Quantile Series (QSER)}
\usage{
qdft2qser(y.qdft)
}
\arguments{
\item{y.qdft}{matrix or array of QDFT from \code{qdft()}}
}
\value{
matrix or array of quantile series
}
\description{
This function computes quantile series (QSER) from QDFT.
}
\examples{
# single time series
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y.qdft <- qdft(y1,tau)
y.qser <- qdft2qser(y.qdft)
plot(y.qser[,1],type='l',xlab="TIME",ylab="QSER")
# multiple time series
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
y.qdft <- qdft(cbind(y1,y2),tau)
y.qser <- qdft2qser(y.qdft)
plot(y.qser[1,,1],type='l',xlab="TIME",ylab="QSER")
}
