% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_pairs_map.R
\name{dist_pairs_map}
\alias{dist_pairs_map}
\title{Creats a map of the distance between pairs of fatty acid signatures}
\usage{
dist_pairs_map(sig_data, dist_meas = 1, gamma = 1)
}
\arguments{
\item{sig_data}{A numeric matrix of fatty acid signatures in column-major
format.}

\item{dist_meas}{An integer indicator of the distance measure to compute.
Default value 1.}

\item{gamma}{The power parameter of the chi-square distance measure. Default
value 1.}
}
\value{
A list containing the following elements:\describe{
  \item{n_sig}{The number of signatures (columns) in \code{sig_data}.}
  \item{sig_1}{The column of \code{sig_data} containing one signature.}
  \item{sig_2}{The column of \code{sig_data} containing the other
    signature.}
  \item{dist}{The distance between signatures \code{sig_1} and \code{sig_2}.}
}
}
\description{
The utility function \code{dist_pairs_map} computes the distance between all
possible pairs of fatty acid signatures within each type of prey or predator.
}
\section{Details}{

This is an internal utility function.  The signature data in \code{sig_data}
are presumed to be ready for analysis, which is best accomplished by a call
to the function \code{prep_sig}.  Consequently, to increase execution
speed during simulations, no numeric error checking is performed.  Please
refer to the documentation for \code{\link{prep_sig}} for additional
information.

Please refer to the documentation for \code{\link{dist_between_2_sigs}} for
additional information regarding distance measures.

Storing the distances between all possible pairs of fatty acid signatures
along with the locations of each pair requires less memory than a square
matrix of all possible pairs, while allowing the location of the signatures
to be easily determined.

Utility functions called by \code{dist_sigs_2_mean}:
  \itemize{
  \item \code{\link{dist_between_2_sigs}}
  }
}

