% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_surv.R
\name{coxmsm.fit}
\alias{coxmsm.fit}
\title{estimating the parameters of a marginal structural model (MSM) based on 
g-computation with quantized exposures}
\usage{
coxmsm.fit(f, qdata, intvals, expnms, main = TRUE, degree = 1,
  id = NULL, MCsize = 10000, ...)
}
\arguments{
\item{f}{an r formula representing the conditional model for the outcome, given all
exposures and covariates. Interaction terms that include exposure variables
should be represented via the \code{\link[base]{AsIs}} function}

\item{qdata}{a data frame with quantized exposures (as well as outcome and other covariates)}

\item{intvals}{sequence, the sequence of integer values that the joint exposure 
is 'set' to for estimating the msm. For quantile g-computation, this is just 
0:(q-1), where q is the number of quantiles of exposure.}

\item{expnms}{a character vector with the names of the columns in qdata that represent
the exposures of interest (main terms only!)}

\item{main}{logical, internal use: produce estimates of exposure effect (psi)
and expected outcomes under g-computation and the MSM}

\item{degree}{polynomial basis function for marginal model (e.g. degree = 2
allows that the relationship between the whole exposure mixture and the outcome
is quadratic. Default=1)}

\item{id}{(optional) NULL, or variable name indexing individual units of 
observation (only needed if analyzing data with multiple observations per 
id/cluster)}

\item{MCsize}{integer: sample size for simulation to approximate marginal 
hazards ratios}

\item{...}{arguments to coxph (e.g. ties)}
}
\description{
this is an internal function called by \code{\link[qgcomp]{qgcomp.cox.noboot}},
 \code{\link[qgcomp]{qgcomp.cox.boot}}, and \code{\link[qgcomp]{qgcomp.cox.noboot}},
 but is documented here for clarity. Generally, users will not need to call
 this function directly.
}
\details{
This function first computes expected outcomes under hypothetical
interventions to simultaneously set all exposures to a specific quantile. These
predictions are based on g-computation, where the exposures are `quantized',
meaning that they take on ordered integer values according to their ranks,
and the integer values are determined by the number of quantile cutpoints used.
The function then takes these expected outcomes and fits an additional model
(a marginal structural model) with the expected outcomes as the outcome and
the intervention value of the exposures (the quantile integer) as the exposure.
Under causal identification assumptions and correct model specification,
the MSM yields a causal exposure-response representing the incremental
change in the expected outcome given a joint intervention on all exposures.
}
\examples{
set.seed(50)
dat <- data.frame(time=(tmg <- pmin(.1,rweibull(50, 10, 0.1))), d=1.0*(tmg<0.1), 
                  x1=runif(50), x2=runif(50), z=runif(50))
expnms=paste0("x", 1:2)
qdata  = qgcomp:::quantize(dat, expnms)$data
f = survival::Surv(time, d)~x1 + x2
fit <- survival::coxph(f, data = qdata, y=TRUE, x=TRUE)
r1 = qdata[1,,drop=FALSE]
times = survival::survfit(fit, newdata=r1, se.fit=FALSE)$time
(obj <- qgcomp:::coxmsm.fit(f, qdata, intvals=c(0,1,2,3), expnms, main=TRUE, degree=1, 
   id=NULL, MCsize=100))
#dat2 <- data.frame(psi=seq(1,4, by=0.1))
#summary(predict(obj))
#summary(predict(obj, newdata=dat2))
}
\seealso{
\code{\link[qgcomp]{qgcomp.cox.boot}}, and \code{\link[qgcomp]{qgcomp.cox.noboot}}
}
\concept{variance mixtures}
