% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{pointwisebound.boot}
\alias{pointwisebound.boot}
\title{Estimating pointwise comparisons for qgcomp.boot objects}
\usage{
pointwisebound.boot(x, alpha = 0.05, pointwiseref = 1)
}
\arguments{
\item{x}{"qgcompfit" object from \code{qgcomp.boot},}

\item{alpha}{alpha level for confidence intervals}

\item{pointwiseref}{referent quantile (e.g. 1 uses the lowest joint-exposure category as
the referent category for calculating all mean differences/standard deviations)}
}
\value{
A data frame containing expected values of the outcome at each quantized value
of all exposures as well as a mean difference contrasting the expected outcome at each
quantized value of all exposures, and associated standard error and confidence intervals.
}
\description{
Calculates: expected outcome (on the link scale), mean difference (link scale)
and the standard error of the mean difference (link scale) for pointwise comparisons
}
\details{
The comparison of interest following a qgcomp fit is often comparisons of model
predictions at various values of the joint-exposures (e.g. expected outcome at all exposures
at the 1st quartile vs. the 3rd quartile). The expected outcome at a given joint exposure,
and marginalized over non-exposure covariates (W), is
given as E(Y^s|S) = sum_w E_w(Y|S,W)Pr(W) = sum_i E(Y_i|S) where Pr(W) is the emprical distribution of
W and S takes on integer values 0 to q-1.
Thus, comparisons are of the type
E_w(Y|S=s) - E_w(Y|S=s2) where s and s2 are two different values of the joint exposures (e.g. 0 and 2).
This function yields E_w(Y|S) as well as E_w(Y|S=s) - E_w(Y|S=p) where s is any value of S and p is
the value chosen via "pointwise ref" - e.g. for binomial variables this will equal the risk/
prevalence difference at all values of S, with the referent category S=p-1. The standard error
of E(Y|S=s) - E(Y|S=p) is calculated from the bootstrap covariance matrix of E_w(Y|S), such that
the standard error for E_w(Y|S=s) - E_w(Y|S=p) is given by

Var(E_w(Y|S=s)) + - Var(E_w(Y|S=p)) - 2*Cov(E_w(Y|S=p), - E_w(Y|S=s))

This is used to create pointwise confidence intervals. Note that this differs slightly from the
\code{\link[qgcomp]{pointwisebound.noboot}} function, which estimates the variance of the conditional
regression line given by E(Y|S,W=w), where w is a vector of medians of W (i.e. predictions
are made at the median value of all covariates).
}
\examples{
set.seed(12)
\dontrun{
n=100
dat <- data.frame(x1=(x1 <- runif(100)), x2=runif(100), x3=runif(100), z=runif(100),
                  y=runif(100)+x1+x1^2)
ft <- qgcomp.boot(y ~ z + x1 + x2 + x3, expnms=c('x1','x2','x3'), data=dat, q=10)
pointwisebound.boot(ft, alpha=0.05, pointwiseref=3)
}
}
\seealso{
\code{\link[qgcomp]{qgcomp.boot}}, \code{\link[qgcomp]{pointwisebound.noboot}}
}
