% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_statistics.R
\name{adjLD}
\alias{adjLD}
\title{LD pruning of summary statistics}
\usage{
adjLD(
  stat = NULL,
  Glist = NULL,
  chr = NULL,
  statistics = "p-value",
  r2 = 0.9,
  ldSets = NULL,
  threshold = 1,
  method = "pruning"
)
}
\arguments{
\item{stat}{a data frame with marker summary statistics (see required format above)}

\item{Glist}{list of information about genotype matrix stored on disk}

\item{chr}{chromosome(s) being processed}

\item{statistics}{specificy what type of statistics ("b" or "z") is being processed (default is "b")}

\item{r2}{threshold used in clumping/pruning procedure (default is 0.9)}

\item{ldSets}{list of marker sets - names corresponds to row names in stat}

\item{threshold}{p-value threshold used in LD pruning}

\item{method}{method used in adjustment for linkage disequilibrium (default is "clumping")}
}
\description{
Perform LD pruning of summary statistics before they are used in gene set enrichment analyses.
}
\keyword{internal}
