% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-state.R
\name{qgis_path}
\alias{qgis_path}
\alias{qgis_version}
\title{Get metadata about the used 'qgis_process' command}
\usage{
qgis_path(query = FALSE, quiet = TRUE)

qgis_version(query = FALSE, quiet = TRUE, full = TRUE, debug = FALSE)
}
\arguments{
\item{query}{Use \code{TRUE} to refresh the cached value.}

\item{quiet}{Use \code{FALSE} to display more information,
possibly useful for debugging.}

\item{full}{Logical.
If \code{FALSE}, only return the \code{"x.y.z"} version string instead of the full
version string that includes the name.
Defaults to \code{TRUE}; ignored if \code{debug = TRUE}.}

\item{debug}{Logical.
If \code{TRUE}, also output the version of QGIS, the operating system and all
relevant libraries, as reported by the 'qgis_process' command.}
}
\value{
A string.
}
\description{
\code{qgis_path()} returns the filepath of the 'qgis_process' command, while
\code{qgis_version()} returns the QGIS version.
}
\examples{
\dontshow{if (has_qgis()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
qgis_path()
qgis_path(quiet = FALSE)
qgis_version()
qgis_version(full = FALSE)
qgis_version(debug = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=qgis_configure]{qgis_configure()}}

Other topics about reporting the QGIS state: 
\code{\link{has_qgis}()},
\code{\link{qgis_algorithms}()},
\code{\link{qgis_using_json_input}()}
}
\concept{functions to manage and explore QGIS and qgisprocess}
\concept{topics about reporting the QGIS state}
