%do not edit, edit noweb/qmrparser.nw
\name{pcAxisCubeMake}
\alias{pcAxisCubeMake}
\title{
        Creates PC-AXIS cube
}

\description{
  From the constructed syntactical tree, structures in R are generated. These structures contain the PC-AXIS cube information.
}

\usage{
pcAxisCubeMake(cstream) 
}
\arguments{
\item{cstream}{tree returned by the PC-AXIS file syntactical analysis }   
}

%\details{}

\value{
  It returns a list with the following elements:
 \item{pxCube (data.frame)}{
    \tabular{ll}{
      headingLength \tab Number of variables in "HEADING".\cr
      StubLength    \tab Number of variables in "STUB".\cr
      frequency     \tab Data frequency if "TIMEVAL" is present. \cr
 }}
 \item{pxCubeVariable (data.frame)}{
    \tabular{ll}{
        variableName  \tab Variable name.\cr
        headingOrStud \tab Indicator, whether the variable appears in "HEADING" or "STUB". \cr
        codesYesNo    \tab Indicator, whether there is "CODES" associated to the variable.\cr
        valuesYesNo   \tab Indicator, whether there is "VALUES" associated to the variable.\cr
        variableOrder \tab Variable order number in "HEADING" or "STUB"\cr
        valueLength   \tab Number of different "CODES" and/or  "VALUES" associated with the variable.\cr
 }}
 \item{pxCubeVariableDomain (data.frame)}{
    \tabular{ll}{
      variableName     \tab Variable name.\cr
      code             \tab Value code when "CODES" is present.\cr
      value            \tab Value literal when "VALUES" is present.\cr
      valueOrder       \tab Variable order number in "CODES" and/or "VALUES".\cr
      eliminationYesNo \tab Indicator, whether the value for the variables is present in "ELIMINATION".\cr
 }}
 \item{pxCubeAttrN}{data.frame list, one for each different parameters cardinalities appearing in "keyword" 
 \itemize{
 \item{pxCubeAttrN$A0 (data.frame)}{
  \tabular{ll}{
        keyword  \tab  Keyword.\cr
        language \tab  Language code o "".\cr
        length   \tab  Number of elements of value list.\cr
        value    \tab  Associated data, keyword[language] = value.\cr
   }}
 \item{pxCubeAttrN$A1 (data.frame)}{
  \tabular{ll}{
        keyword  \tab Keyword.\cr
        language \tab Language code o "".\cr
        arg1     \tab Argument value.\cr
        length   \tab Number of elements of value list.\cr
        value    \tab Associated data , keyword[language](arg) = value.\cr
  }}
 \item{pxCubeAttrN$A2 (data.frame)}{
  \tabular{ll}{
        keyword  \tab Keyword.\cr
        language \tab Language code o "".\cr
        arg1     \tab Argument one value.\cr
        arg2     \tab Argument to value.\cr
        length   \tab Value list number of elements.\cr
        value    \tab Associated data , keyword[language](arg1,arg2) = value.\cr
 }}
 }}

 \item{pxCubeData (data.frame)}{
  \tabular{ll}{
        StubLength + headingLength columns \tab, with variables values, ordered according to "STUB" and followed by those appearing in "HEADING".
        
        Variables names correspond to variable names.\cr
        data \tab associated value.\cr
  }}

  Returned value short version is:
 \preformatted{
Value:
 pxCube              (headingLength, StubLength)
 pxCubeVariable      (variableName , headingOrStud, codesYesNo, valuesYesNo, variableOrder, valueLength)
 pxCubeVariableDomain(variableName , code, value, valueOrder, eliminationYesNo)
 pxCubeAttr          -> list pxCubeAttrN(key, {variableName} , value)
 pxCubeData          ({variableName}+, data)   varia signatura

}

}
\examples{

  \dontrun{
    ## significant time reductions may be achieve by doing:
    library("compiler")
    enableJIT(level=3)
  }
  
  name     <- system.file("extdata","datInSFexample6_1.px", package = "qmrparser")
  
  stream   <- streamParserFromFileName(name,encoding="UTF-8")
  
  cstream  <-  pcAxisParser(stream)
  if ( cstream$status == 'ok' ) {
    cube <- pcAxisCubeMake(cstream)
    
    ## Variables
    print(cube$pxCubeVariable)
    
    ## Data
    print(cube$pxCubeData)

  }
  
  \dontrun{
      #
      # Error messages like
      #                " ... invalid multibyte string ... "
      # or warnings
      #                " input string ...  is invalid in this locale"
      #
      # For example, in Linux the error generated by this code:
       name     <-     "http://www.ine.es/pcaxisdl//t20/e245/p04/a2009/l0/00000008.px" 
      stream   <- streamParserFromString( readLines( name ) )    
      cstream  <- pcAxisParser(stream)
      if ( cstream$status == 'ok' )  cube <- pcAxisCubeMake(cstream)
      #
      # is caused by files with a non-readable 'encoding'. In the case where it could be read, there may also be problems with string-handling functions, due to multibyte characters. In Windows, according to \code{link{Sys.getlocale}()}, file may be read but accents, ñ, ... may not be correctly recognised.

      #
      # There are, at least, the following options:
      #  - File conversion to utf-8, from the OS, with
      # "iconv - Convert encoding of given files from one encoding to another"
      #
      #  - File conversion in R:
      name    <- "http://www.ine.es/pcaxisdl//t20/e245/p04/a2009/l0/00000008.px" 
      stream   <- streamParserFromString( iconv( readLines( name ), "IBM850", "UTF-8") )
      cstream  <- pcAxisParser(stream)
      if ( cstream$status == 'ok' )  cube <- pcAxisCubeMake(cstream)
      #
      # In the latter case, latin1 would also work, but accents, ñ, ... would not be correctly read.
      #
      #  - Making the assumption that the file does not contain multibyte characters:
      #
      localeOld <- Sys.getlocale("LC_CTYPE")
      Sys.setlocale(category = "LC_CTYPE", locale = "C")
      #
      name     <-
        "http://www.ine.es/pcaxisdl//t20/e245/p04/a2009/l0/00000008.px" 
      stream   <- streamParserFromString( readLines( name ) )
      cstream  <- pcAxisParser(stream)
      if ( cstream$status == 'ok' )  cube <- pcAxisCubeMake(cstream)
      #
      Sys.setlocale(category = "LC_CTYPE", locale = localeOld)
      #
      # However, some characters will not be correctly read (accents, ñ, ...)

    }
    
}  
\references{
  
  PC-Axis file format. 
  
  \url{http://www.scb.se/Pages/List____314011.aspx}
 
  
  PC-Axis file format manual. Statistics of Finland.
  
  \url{http://tilastokeskus.fi/tup/pcaxis/tiedostomuoto2006_laaja_en.pdf} 
  
} 

\keyword{PC-AXIS}
