% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_files.R
\name{qread}
\alias{qread}
\title{qread}
\usage{
qread(file)
}
\arguments{
\item{file}{the file name/path}
}
\value{
The de-serialized object
}
\description{
Reads a object in a file serialized to disk
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE), 
                 num = rnorm(1e3), 
                 char = randomStrings(1e3), stringsAsFactors = FALSE)
myfile <- tempfile()
qsave(x, myfile)
x2 <- qread(myfile)
identical(x, x2) # returns true

z <- 1:1e7
myfile <- tempfile()
qsave(z, myfile)
z2 <- qread(myfile)
identical(z, z2) # returns true

w <- as.list(rnorm(1e6))
myfile <- tempfile()
qsave(w, myfile)
w2 <- qread(myfile)
identical(w, w2) # returns true
}
