% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{zstd_compress_raw}
\alias{zstd_compress_raw}
\title{Zstd compression}
\usage{
zstd_compress_raw(x, compress_level)
}
\arguments{
\item{x}{The object to serialize.}

\item{compress_level}{The compression level used (default \code{4}). A number between \code{-50} to \code{22} (higher is more compressed). Due to the format of qs, there is
very little benefit to compression levels > 5 or so.}
}
\value{
The compressed data as a raw vector.
}
\description{
Compresses to a raw vector using the zstd algorithm. Exports the main zstd compression function.
}
\examples{
x <- 1:1e6
xserialized <- serialize(x, connection=NULL)
xcompressed <- zstd_compress_raw(xserialized, compress_level = 1)
xrecovered <- unserialize(zstd_decompress_raw(xcompressed))
}
