% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cqgate.R
\docType{class}
\name{cqgate}
\alias{cqgate}
\alias{cqgate-class}
\title{A controlled single qubit gate}
\description{
This class represents a generic controlled gate
}
\details{
The qubits are counted from 1 to \code{nbits} starting with the least
significant bit.
}
\section{Slots}{

\describe{
\item{\code{bits}}{Integer. Integer vector of bits. The first is the control bit, the second the target bit.}

\item{\code{gate}}{sqgate. The single qubit gate.}
}}

\examples{
x <- H(1) * qstate(nbits=2)
## application of the CX (CNOT) gate to bit 1,2
z <- cqgate(bits=c(1L, 2L), gate=X(2L)) * x
z
## the same as, but differently implemented
z <- CNOT(c(1,2)) * x
z

}
