% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yacas.R
\name{as.function.qspray}
\alias{as.function.qspray}
\title{Multivariate polynomial as function}
\usage{
\method{as.function}{qspray}(x, ...)
}
\arguments{
\item{x}{object of class \code{qspray}}

\item{...}{ignored}
}
\value{
A function having the same variables as the polynomial. It returns 
  a string.
}
\description{
Coerces a \code{qspray} polynomial into a function.
}
\examples{
library(qspray)
P <- (qlone(1) + "1/2"*qlone(2))^2 + 5
f <- as.function(P)
f(2, "3/7")
f("x", "y")
# the evaluation is performed by (R)yacas and complex numbers are
# allowed; the imaginary unit is denoted by `I`
f("2 + 2*I", "1/4")
}
