% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsprayDivision.R
\name{qsprayDivision}
\alias{qsprayDivision}
\title{Division of two polynomials}
\usage{
qsprayDivision(qsprayA, qsprayB)
}
\arguments{
\item{qsprayA}{a \code{qspray} object, the dividend}

\item{qsprayB}{a \code{qspray} object, the divisor}
}
\value{
A list with two \code{qspray} objects, the quotient and the 
  remainder.
}
\description{
Division of two polynomials
}
\examples{
library(qspray)
x <- qlone(1)
y <- qlone(2)
z <- qlone(3)
B <- x*y^2 + z*x^2 + 1
A <- B * (x^2*y^2*z^2 - 3) + x*y
divis <- qsprayDivision(A, B)
B * divis[["Q"]] + divis[["R"]] == A # should be TRUE
}
