% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan1max.R
\name{scan1max}
\alias{scan1max}
\title{Maximum LOD score from genome scan with a single-QTL model}
\usage{
scan1max(
  genoprobs,
  pheno,
  kinship = NULL,
  addcovar = NULL,
  Xcovar = NULL,
  intcovar = NULL,
  weights = NULL,
  reml = TRUE,
  model = c("normal", "binary"),
  hsq = NULL,
  by_chr = FALSE,
  cores = 1,
  ...
)
}
\arguments{
\item{genoprobs}{Genotype probabilities as calculated by
\code{\link[=calc_genoprob]{calc_genoprob()}}.}

\item{pheno}{A numeric matrix of phenotypes, individuals x phenotypes.}

\item{kinship}{Optional kinship matrix, or a list of kinship matrices (one
per chromosome), in order to use the LOCO (leave one chromosome
out) method.}

\item{addcovar}{An optional numeric matrix of additive covariates.}

\item{Xcovar}{An optional numeric matrix with additional additive covariates used for
null hypothesis when scanning the X chromosome.}

\item{intcovar}{An numeric optional matrix of interactive covariates.}

\item{weights}{An optional numeric vector of positive weights for the
individuals. As with the other inputs, it must have \code{names}
for individual identifiers.}

\item{reml}{If \code{kinship} provided: if \code{reml=TRUE}, use
REML; otherwise maximum likelihood.}

\item{model}{Indicates whether to use a normal model (least
squares) or binary model (logistic regression) for the phenotype.
If \code{model="binary"}, the phenotypes must have values in \eqn{[0, 1]}.}

\item{hsq}{Considered only if \code{kinship} is provided, in which case
this is taken as the assumed value for the residual
heritability. It should be a vector with length corresponding
to the number of columns in \code{pheno}, or (if \code{kinship}
corresponds to a list of LOCO kinship matrices) a matrix with dimension
\verb{length(kinship) x ncol(pheno)}.}

\item{by_chr}{If TRUE, save the individual chromosome maxima.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}

\item{...}{Additional control parameters; see Details.}
}
\value{
Either a vector of genome-wide maximum LOD scores, or if
\code{by_chr} is TRUE, a matrix with the chromosome-specific maxima,
with the rows being the chromosomes and the columns being the
phenotypes.
}
\description{
Maximum LOD score from genome scan with a single-QTL model by
Haley-Knott regression or a linear mixed model, with possible
allowance for covariates.
}
\details{
Equivalent to running \code{scan1()} and then saving the column
maxima, with some savings in memory usage.
}
\examples{
# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
\dontshow{iron <- iron[,c("19", "X")] # subset to chr 19 and X}

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# grab phenotypes and covariates; ensure that covariates have names attribute
pheno <- iron$pheno
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)
Xcovar <- get_x_covar(iron)

# perform genome scan
out <- scan1max(probs, pheno, addcovar=covar, Xcovar=Xcovar)

}
\seealso{
\code{\link[=scan1]{scan1()}}, \code{\link[=scan1perm]{scan1perm()}}
}
