% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_pseudomarkers.R
\name{insert_pseudomarkers}
\alias{insert_pseudomarkers}
\title{Insert pseudomarkers into a marker map}
\usage{
insert_pseudomarkers(
  map,
  step = 0,
  off_end = 0,
  stepwidth = c("fixed", "max"),
  pseudomarker_map = NULL,
  tol = 0.01,
  cores = 1
)
}
\arguments{
\item{map}{A list of numeric vectors; each vector gives marker
positions for a single chromosome.}

\item{step}{Distance between pseudomarkers and markers; if
\code{step=0} no pseudomarkers are inserted.}

\item{off_end}{Distance beyond terminal markers in which to insert
pseudomarkers.}

\item{stepwidth}{Indicates whether to use a fixed grid
(\code{stepwidth="fixed"}) or to use the maximal distance between
pseudomarkers to ensure that no two adjacent markers/pseudomarkers
are more than \code{step} apart.}

\item{pseudomarker_map}{A map of pseudomarker locations; if provided the
\code{step}, \code{off_end}, and \code{stepwidth} arguments are
ignored.}

\item{tol}{Tolerance for determining whether a pseudomarker would duplicate a marker position.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
A list like the input \code{map} with pseudomarkers
inserted. Will also have an attribute \code{"is_x_chr"}, taken
from the input \code{map}.
}
\description{
Insert pseudomarkers into a map of genetic markers
}
\details{
If \code{stepwidth="fixed"}, a grid of pseudomarkers is
added to the marker map.

If \code{stepwidth="max"}, a minimal set of pseudomarkers are
added, so that the maximum distance between adjacent markers or
pseudomarkers is at least \code{step}. If two adjacent markers are
separated by less than \code{step}, no pseudomarkers will be added
to the interval. If they are more then \code{step} apart, a set of
equally-spaced pseudomarkers will be added.

If \code{pseudomarker_map} is provided, then the \code{step},
\code{off_end}, and \code{stepwidth} arguments are ignored, and the
input \code{pseudomarker_map} is taken to be the set of
pseudomarker positions.
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
gmap_w_pmar <- insert_pseudomarkers(iron$gmap, step=1)
}
\seealso{
\code{\link[=calc_genoprob]{calc_genoprob()}}, \code{\link[=calc_grid]{calc_grid()}}
}
\keyword{utilities}
