% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_cross2.R
\name{basic_summaries}
\alias{basic_summaries}
\alias{n_ind}
\alias{n_ind_geno}
\alias{n_ind_pheno}
\alias{n_ind_covar}
\alias{n_ind_gnp}
\alias{ind_ids}
\alias{ind_ids_geno}
\alias{ind_ids_pheno}
\alias{ind_ids_covar}
\alias{ind_ids_gnp}
\alias{n_chr}
\alias{n_founders}
\alias{founders}
\alias{chr_names}
\alias{tot_mar}
\alias{n_mar}
\alias{marker_names}
\alias{n_pheno}
\alias{pheno_names}
\alias{n_covar}
\alias{covar_names}
\alias{n_phenocovar}
\alias{phenocovar_names}
\title{Basic summaries of a cross2 object}
\usage{
n_ind(cross2)

n_ind_geno(cross2)

n_ind_pheno(cross2)

n_ind_covar(cross2)

n_ind_gnp(cross2)

ind_ids(cross2)

ind_ids_geno(cross2)

ind_ids_pheno(cross2)

ind_ids_covar(cross2)

ind_ids_gnp(cross2)

n_chr(cross2)

n_founders(cross2)

founders(cross2)

chr_names(cross2)

tot_mar(cross2)

n_mar(cross2)

marker_names(cross2)

n_pheno(cross2)

pheno_names(cross2)

n_covar(cross2)

covar_names(cross2)

n_phenocovar(cross2)

phenocovar_names(cross2)
}
\arguments{
\item{cross2}{An object of class \code{"cross2"}, as output by \code{\link[=read_cross2]{read_cross2()}}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}
}
\value{
Variously a number, vector of numbers, or vector of character strings.
}
\description{
Basic summaries of a cross2 object.
}
\section{Functions}{
\itemize{
\item \code{n_ind()}: Number of individuals (either genotyped or phenotyped)

\item \code{n_ind_geno()}: Number of genotyped individuals

\item \code{n_ind_pheno()}: Number of phenotyped individuals

\item \code{n_ind_covar()}: Number of individuals with covariate data

\item \code{n_ind_gnp()}: Number of individuals with both genotype and phenotype data

\item \code{ind_ids()}: IDs of individuals (either genotyped or phenotyped)

\item \code{ind_ids_geno()}: IDs of genotyped individuals

\item \code{ind_ids_pheno()}: IDs of phenotyped individuals

\item \code{ind_ids_covar()}: IDs of individuals with covariate data

\item \code{ind_ids_gnp()}: IDs of individuals with both genotype and phenotype data

\item \code{n_chr()}: Number of chromosomes

\item \code{n_founders()}: Number of founder strains

\item \code{founders()}: Names of founder strains

\item \code{chr_names()}: Chromosome names

\item \code{tot_mar()}: Total number of markers

\item \code{n_mar()}: Number of markers on each chromosome

\item \code{marker_names()}: Marker names

\item \code{n_pheno()}: Number of phenotypes

\item \code{pheno_names()}: Phenotype names

\item \code{n_covar()}: Number of covariates

\item \code{covar_names()}: Covariate names

\item \code{n_phenocovar()}: Number of phenotype covariates

\item \code{phenocovar_names()}: Phenotype covariate names

}}
\seealso{
\code{\link[=summary.cross2]{summary.cross2()}}
}
\keyword{utilities}
