% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_scan1.R
\name{max_scan1}
\alias{max_scan1}
\alias{max.scan1}
\title{Find position with maximum LOD score}
\usage{
max_scan1(
  scan1_output,
  map = NULL,
  lodcolumn = 1,
  chr = NULL,
  na.rm = TRUE,
  ...
)

\method{max}{scan1}(scan1_output, map = NULL, lodcolumn = 1, chr = NULL, na.rm = TRUE, ...)
}
\arguments{
\item{scan1_output}{An object of class \code{"scan1"} as returned by
\code{\link[=scan1]{scan1()}}.}

\item{map}{A list of vectors of marker positions, as produced by
\code{\link[=insert_pseudomarkers]{insert_pseudomarkers()}}. Can also be an indexed SNP info table,
as from \code{\link[=index_snps]{index_snps()}} or \code{\link[=scan1snps]{scan1snps()}}.}

\item{lodcolumn}{An integer or character string indicating the LOD
score column, either as a numeric index or column name.
If \code{NULL}, return maximum for all columns.}

\item{chr}{Optional vector of chromosomes to consider.}

\item{na.rm}{Ignored (take to be TRUE)}

\item{...}{Ignored}
}
\value{
If \code{map} is NULL, the genome-wide maximum LOD score for the selected column is returned.
If also \code{lodcolumn} is NULL, you get a vector with the maximum LOD for each column.

If \code{map} is provided, the return value is a data.frame with three columns: chr, pos, and lod score.
But if \code{lodcolumn} is NULL, you get the maximum for each lod score column, in the format provided by
\code{\link[=find_peaks]{find_peaks()}}, so a data.frame with five columns: lodindex, lodcolumn, chr, pos, and lod.
}
\description{
Return data frame with the positions having maximum LOD score for a
particular LOD score column
}
\examples{
# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# grab phenotypes and covariates; ensure that covariates have names attribute
pheno <- iron$pheno
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)
Xcovar <- get_x_covar(iron)

# perform genome scan
out <- scan1(probs, pheno, addcovar=covar, Xcovar=Xcovar)

# maximum of first column
max(out, map)

# maximum of spleen column
max(out, map, lodcolumn="spleen")

# maximum of first column on chr 2
max(out, map, chr="2")
}
