% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_unique_geno.R
\name{count_unique_geno}
\alias{count_unique_geno}
\title{Count the unique genotypes for each row of a genotype matrix}
\usage{
count_unique_geno(genotypes, na.strings = c("N", "H", "NA", ""), cores = 1)
}
\arguments{
\item{genotypes}{Matrix of genotypes (markers x individuals)}

\item{na.strings}{Genotypes to be considered as missing values.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
Vector of counts of unique genotypes.
}
\description{
For genotype data (markers x individuals) on a set of individuals,
count the unique genotypes for each marker
}
\examples{
g <- rbind(c("NA", "A",  "A",  "A", "T"),
           c("NA", "NA", "NA", "A", "A"),
           c("A",  "A",  "T",  "G", "G"),
           c("C", "C",  "G",  "G", "NA"))
counts <- count_unique_geno(g)
}
\seealso{
\code{\link[=find_unique_geno]{find_unique_geno()}}
}
