% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_unique_geno.R
\name{find_unique_geno}
\alias{find_unique_geno}
\title{Find the unique genotypes for each row of a genotype matrix}
\usage{
find_unique_geno(genotypes, na.strings = c("N", "H", "NA", ""), cores = 1)
}
\arguments{
\item{genotypes}{Matrix of genotypes (markers x individuals)}

\item{na.strings}{Genotypes to be considered as missing values.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
Matrix with two columns. Each row corresponds to a marker,
and has the two unique genotypes, or \code{NA}s (if >2 or <2 unique
genotypes).
}
\description{
For genotype data (markers x individuals) on a set of individuals,
find the unique genotypes for each marker, provided that there are exactly two.
(If more than two or fewer than two, return NAs.)
}
\examples{
g <- rbind(c("NA", "A",  "A",  "A", "T"),
           c("NA", "NA", "NA", "A", "A"),
           c("A",  "A",  "T",  "G", "G"),
           c("C", "C",  "G",  "G", "NA"))
ug <- find_unique_geno(g)
}
\seealso{
\code{\link[=count_unique_geno]{count_unique_geno()}}, \code{\link[=encode_geno]{encode_geno()}}
}
