% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross2_do_to_genail8.R
\name{cross2_do_to_genail8}
\alias{cross2_do_to_genail8}
\alias{cross2_do_to_genail}
\title{Convert cross2 object from do to genail8}
\usage{
cross2_do_to_genail8(cross)

cross2_do_to_genail(cross)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}, as produced by
\code{\link[qtl2:read_cross2]{qtl2::read_cross2()}}.}
}
\value{
The input object \code{cross} with cross type changed to
class \code{"genail8"} and the cross information revised to match.
}
\description{
Convert a cross2 object from cross type \code{"do"} to cross type \code{"genail8"}.
}
\examples{
\dontrun{
file <- paste0("https://raw.githubusercontent.com/rqtl/",
               "qtl2data/master/DOex/DOex.zip")
DOex <- read_cross2(file)

DOex_genail <- cross2_do_to_genail8(DOex)
}
}
