% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross2_ril_to_genril.R
\name{cross2_ril_to_genril}
\alias{cross2_ril_to_genril}
\title{Convert cross2 object from ril to genril}
\usage{
cross2_ril_to_genril(cross)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}, as produced by
\code{\link[qtl2:read_cross2]{qtl2::read_cross2()}}.}
}
\value{
The input object \code{cross} with cross type changed to
class \code{"genriln"} for some value of \code{n},
and the cross information revised to match.
}
\description{
Convert a cross2 object from cross type \code{"risibn"} to cross type \code{"genriln"}.
}
\examples{
\dontrun{
file <- paste0("https://raw.githubusercontent.com/rqtl/",
               "qtl2data/master/CC/cc.zip")
cc <- read_cross2(file)

cc_genril <- cross2_ril_to_genril(cc)
}

\dontrun{
file <- paste0("https://raw.githubusercontent.com/rqtl/",
               "qtl2data/master/ArabMAGIC/arabmagic_tair9.zip")
arab <- read_cross2(file)

arab_genril <- cross2_ril_to_genril(arab)
}
}
