% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_list_to_df.R
\name{map_list_to_df}
\alias{map_list_to_df}
\title{Marker map list to data frame}
\usage{
map_list_to_df(
  map_list,
  chr_column = "chr",
  pos_column = "pos",
  marker_column = "marker"
)
}
\arguments{
\item{map_list}{List of vectors containing marker positions}

\item{chr_column}{Name of the chromosome column in the output}

\item{pos_column}{Name of the position column in the output}

\item{marker_column}{Name of the marker column in the output.
If NULL, just put them as row names.}
}
\value{
A data frame with the marker positions.
}
\description{
Convert a marker map organized as a list to a data frame
}
\examples{
library(qtl2)
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
iron_map <- map_list_to_df(iron$gmap)

}
\seealso{
\code{\link[=map_df_to_list]{map_df_to_list()}}
}
