% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_scan1.R, R/ggplot_scan1_internal.R
\name{ggplot_scan1}
\alias{ggplot_scan1}
\alias{autoplot.scan1}
\alias{ggplot_scan1_internal}
\title{Plot a genome scan}
\usage{
ggplot_scan1(
  x,
  map,
  lodcolumn = 1,
  chr = NULL,
  gap = 25,
  bgcolor = "gray90",
  altbgcolor = "gray85",
  ...
)

\method{autoplot}{scan1}(
  x,
  map,
  lodcolumn = 1,
  chr = NULL,
  gap = 25,
  bgcolor = "gray90",
  altbgcolor = "gray85",
  ...
)

ggplot_scan1_internal(
  map,
  lod,
  gap = 25,
  col = NULL,
  shape = NULL,
  pattern = NULL,
  facet = NULL,
  patterns = c("none", "all", "hilit"),
  ...
)
}
\arguments{
\item{x}{Output of \code{\link[qtl2]{scan1}}.}

\item{map}{Map of pseudomarker locations.}

\item{lodcolumn}{LOD score column to plot (a numeric index, or a
character string for a column name). One or more value(s) allowed.}

\item{chr}{Selected chromosomes to plot; a vector of character
strings.}

\item{gap}{Gap between chromosomes.}

\item{bgcolor}{Background color for the plot.}

\item{altbgcolor}{Background color for alternate chromosomes.}

\item{...}{Additional graphics parameters.}

\item{lod}{Matrix of lod (or other) values.}

\item{col}{Colors for points or lines, with labels.}

\item{shape}{Shapes for points.}

\item{pattern}{Use to group values for plotting (default = \code{NULL}); typically provided by \code{\link{plot_snpasso}} internal routine.}

\item{facet}{Plot facets if multiple phenotypes and group provided (default = \code{NULL}).}

\item{patterns}{Connect SDP patterns: one of \code{c("none","all","hilit")}.}
}
\value{
None.
}
\description{
Plot LOD curves for a genome scan

Plot LOD curves for a genome scan
}
\examples{
# load qtl2 package for data and genoprob calculation
library(qtl2)

# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# grab phenotypes and covariates; ensure that covariates have names attribute
pheno <- iron$pheno
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)
Xcovar <- get_x_covar(iron)

# perform genome scan
out <- scan1(probs, pheno, addcovar=covar, Xcovar=Xcovar)

# plot the results for selected chromosomes
chr <- c(2,7,8,9,15,16)
ggplot_scan1(out, map, lodcolumn=1:2, chr=chr, col=c("darkslateblue","violetred"),
     legend.position=c(0.1,0.9))

# plot just one chromosome
ggplot_scan1(out, map, chr=8, lodcolumn=1:2, col=c("darkblue","violetred"))

# can also use autoplot from ggplot2
# lodcolumn can also be a column name
library(ggplot2)
autoplot(out, map, chr=8, lodcolumn=c("liver","spleen"), col=c("darkblue","violetred"))
}
\seealso{
\code{\link{ggplot_coef}}, \code{\link{ggplot_snpasso}}
}
