% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_scan1.R
\name{summary_scan1}
\alias{summary_scan1}
\alias{summary.scan1}
\title{Summary of scan1 object}
\usage{
summary_scan1(
  object,
  map,
  snpinfo = NULL,
  lodcolumn = seq_len(ncol(object)),
  chr = names(map),
  sum_type = c("common", "best"),
  drop = 1.5,
  show_all_snps = TRUE,
  ...
)

\method{summary}{scan1}(object, ...)
}
\arguments{
\item{object}{object from \code{\link[qtl2]{scan1}}}

\item{map}{A list of vectors of marker positions, as produced by
\code{\link[qtl2]{insert_pseudomarkers}}.}

\item{snpinfo}{Data frame with SNP information with the following
    columns (the last three are generally derived from with
    \code{\link[qtl2]{index_snps}}):
\itemize{
\item \code{chr} - Character string or factor with chromosome
\item \code{pos} - Position (in same units as in the \code{"map"}
    attribute in \code{genoprobs}.
\item \code{sdp} - Strain distribution pattern: an integer, between
    1 and \eqn{2^n - 2} where \eqn{n} is the number of strains, whose
    binary encoding indicates the founder genotypes
\item \code{snp} - Character string with SNP identifier (if
    missing, the rownames are used).
\item \code{index} - Indices that indicate equivalent
    groups of SNPs.
\item \code{intervals} - Indexes that indicate which marker
    intervals the SNPs reside.
\item \code{on_map} - Indicate whether SNP coincides with a marker
    in the \code{genoprobs}
}}

\item{lodcolumn}{one or more lod columns}

\item{chr}{one or more chromosome IDs}

\item{sum_type}{type of summary}

\item{drop}{LOD drop from maximum}

\item{show_all_snps}{show all SNPs if \code{TRUE}}

\item{...}{other arguments not used}
}
\value{
tbl summary
}
\description{
Summary of scan1 object
}
\examples{
# read data
iron <- qtl2::read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
# insert pseudomarkers into map
map <- qtl2::insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- qtl2::calc_genoprob(iron, map, error_prob=0.002)

# grab phenotypes and covariates; ensure that covariates have names attribute
pheno <- iron$pheno
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)
Xcovar <- qtl2::get_x_covar(iron)

# perform genome scan
out <- qtl2::scan1(probs, pheno, addcovar=covar, Xcovar=Xcovar)

# summary
summary(out, map)

}
\author{
Brian S Yandell, \email{brian.yandell@wisc.edu}
}
\keyword{utilities}
