% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplotCurves.R
\name{iplotCurves}
\alias{iplotCurves}
\title{Plot of a bunch of curves, linked to points in scatterplots}
\usage{
iplotCurves(curveMatrix, times, scatter1 = NULL, scatter2 = NULL,
  group = NULL, chartOpts = NULL)
}
\arguments{
\item{curveMatrix}{Matrix (dim n_ind x n_times) with outcomes}

\item{times}{Vector (length n_times) with time points for the
columns of curveMatrix}

\item{scatter1}{Matrix (dim n_ind x 2) with data for the first
scatterplot}

\item{scatter2}{Matrix (dim n_ind x 2) with data for the second
scatterplot}

\item{group}{Optional vector of groups of individuals (e.g., a genotype)}

\item{chartOpts}{A list of options for configuring the chart (see
the coffeescript code). Each element must be named using the
corresponding option.}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive graph with a panel having a number of curves
(say, a phenotype measured over time) linked to one or two (or no) scatter plots
(say, of the first vs middle and middle vs last times).
}
\examples{
# random growth curves, based on some data
times <- 1:16
n <- 100
start <- rnorm(n, 5.2, 0.8)
slope1to5 <- rnorm(n, 2.6, 0.5)
slope5to16 <- rnorm(n, 0.24 + 0.09*slope1to5, 0.195)
y <- matrix(ncol=16, nrow=n)
y[,1] <- start
for(j in 2:5)
    y[,j] <- y[,j-1] + slope1to5
for(j in 6:16)
    y[,j] <- y[,j-1] + slope5to16
y <- y + rnorm(prod(dim(y)), 0, 0.35)

\donttest{
iplotCurves(y, times, y[,c(1,5)], y[,c(5,16)],
            chartOpts=list(curves_xlab="Time", curves_ylab="Size",
                           scat1_xlab="Size at T=1", scat1_ylab="Size at T=5",
                           scat2_xlab="Size at T=5", scat2_ylab="Size at T=16"))}

}
\seealso{
\code{\link{iplotCorr}}
}
\keyword{hplot}

