% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estQTLeffects.R
\name{cbindQTLeffects}
\alias{cbindQTLeffects}
\title{Combine multiple runs of estQTLeffects}
\usage{
cbindQTLeffects(..., labels)
}
\arguments{
\item{...}{Results of \code{\link{estQTLeffects}}}

\item{labels}{Vector of labels to use in the combination.}
}
\value{
list of matrices; each component corresponds to a position
in the genome and is a matrix with phenotypes x effects
}
\description{
Combine multiple runs of estQTLeffects by applying cbind to each
component
}
\examples{
library(qtl)
data(fake.f2)
fake.f2 <- calc.genoprob(fake.f2)
sex <- fake.f2$pheno$sex
eff.fem <- estQTLeffects(fake.f2[,sex==0], pheno.col=1)
eff.mal <- estQTLeffects(fake.f2[,sex==1], pheno.col=1)
eff <- cbindQTLeffects(eff.fem, eff.mal, labels=c("female", "male"))

}
\seealso{
\code{\link{estQTLeffects}}
}
\keyword{utilities}

