% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remim.R
\name{remim}
\alias{remim}
\alias{print.qtlpoly.remim}
\title{Random-effect multiple interval mapping (REMIM)}
\usage{
remim(
  data,
  pheno.col = NULL,
  w.size = 15,
  sig.fwd = 0.01,
  sig.bwd = 1e-04,
  score.null = NULL,
  d.sint = 1.5,
  polygenes = FALSE,
  n.clusters = NULL,
  n.rounds = Inf,
  plot = NULL,
  verbose = TRUE
)

\method{print}{qtlpoly.remim}(x, pheno.col = NULL, sint = NULL, ...)
}
\arguments{
\item{data}{an object of class \code{qtlpoly.data}.}

\item{pheno.col}{a numeric vector with the phenotype columns to be analyzed or printed; if \code{NULL} (default), all phenotypes from \code{'data'} will be included.}

\item{w.size}{the window size (in centiMorgans) to avoid on either side of QTL already in the model when looking for a new QTL, e.g. 15 (default).}

\item{sig.fwd}{the desired score-based significance level for forward search, e.g. 0.01 (default).}

\item{sig.bwd}{the desired score-based significance level for backward elimination, e.g. 0.001 (default).}

\item{score.null}{an object of class \code{qtlpoly.null} with results of score statistics from resampling.}

\item{d.sint}{a \eqn{d} value to subtract from logarithm of \emph{p}-value (\eqn{LOP-d}) for support interval calculation, e.g. \eqn{d=1.5} (default) represents approximate 95\% support interval.}

\item{polygenes}{if \code{TRUE} all QTL already in the model are treated as a single polygenic effect; if \code{FALSE} (default) all QTL effect variances have to estimated.}

\item{n.clusters}{number of parallel processes to spawn.}

\item{n.rounds}{number of search rounds; if \code{Inf} (default) forward search will stop when no more significant positions can be found.}

\item{plot}{a suffix for the file's name containing plots of every algorithm step, e.g. "remim"; if \code{NULL} (default), no file is produced.}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if \code{FALSE}, no output is produced.}

\item{x}{an object of class \code{qtlpoly.remim} to be printed.}

\item{sint}{whether \code{"upper"} or \code{"lower"} support intervals should be printed; if \code{NULL} (default), only QTL peak information will be printed.}

\item{...}{currently ignored}
}
\value{
An object of class \code{qtlpoly.remim} which contains a list of \code{results} for each trait with the following components:

    \item{pheno.col}{a phenotype column number.}
    \item{stat}{a vector containing values from score statistics.}
    \item{pval}{a vector containing \emph{p}-values from score statistics.}
    \item{qtls}{a data frame with information from the mapped QTL.}
    \item{lower}{a data frame with information from the lower support interval of mapped QTL.}
    \item{upper}{a data frame with information from the upper support interval of mapped QTL.}
}
\description{
Automatic function that performs REMIM algorithm using score statistics.
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Search for QTL
  remim.mod = remim(data = data, pheno.col = 1, w.size = 15, sig.fwd = 0.0011493379,
sig.bwd = 0.0002284465, d.sint = 1.5, n.clusters = 1)
  }

}
\references{
Kao CH, Zeng ZB, Teasdale RD (1999) Multiple interval mapping for quantitative trait loci. \emph{Genetics} 152 (3): 1203–16. 

    Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
    
    Qu L, Guennel T, Marshall SL (2013) Linear score tests for variance components in linear mixed models and applications to genetic association studies. \emph{Biometrics} 69 (4): 883–92.

    Zou F, Fine JP, Hu J, Lin DY (2004) An efficient resampling method for assessing genome-wide statistical significance in mapping quantitative trait loci. \emph{Genetics} 168 (4): 2307-16. \doi{10.1534/genetics.104.031427}
}
\seealso{
\code{\link[qtlpoly]{read_data}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
