% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_Quadtree.R
\name{add_legend}
\alias{add_legend}
\title{Add a gradient legend to a plot}
\usage{
add_legend(
  zlim,
  col,
  alpha = 1,
  lgd_box_col = NULL,
  lgd_x_pct = 0.5,
  lgd_y_pct = 0.5,
  lgd_wd_pct = 0.5,
  lgd_ht_pct = 0.5,
  bar_box_col = "black",
  bar_wd_pct = 0.2,
  bar_ht_pct = 1,
  ticks = NULL,
  ticks_n = 5,
  ticks_x_pct = 1
)
}
\arguments{
\item{zlim}{two-element numeric vector; required; the min and max value of z}

\item{col}{character vector; required; the colors that will be used in the
legend.}

\item{alpha}{numeric; transparency of the colors. Must be in the range
0-1, where 0 is fully transparent and 1 is fully opaque. Default is 1.}

\item{lgd_box_col}{character; color of the box to draw around the entire
legend. If \code{NULL} (the default), no box is drawn}

\item{lgd_x_pct}{numeric; location of the center of the legend in the
x-dimension, as a fraction (0 to 1) of the \emph{right margin area},
\strong{not} the entire width of the figure}

\item{lgd_y_pct}{numeric; location of the center of the legend in the
y-dimension, as a fraction (0 to 1). Unlike \code{lgd_x_pct}, this
\strong{is} relative to the entire figure height (since the right margin
area spans the entire vertical dimension)}

\item{lgd_wd_pct}{numeric; width of the entire legend, as a fraction (0 to 1)
of the right margin width}

\item{lgd_ht_pct}{numeric; height of the entire legend, as a fraction (0 to
1) of the figure height}

\item{bar_box_col}{character; color of the box to draw around the color bar.
If \code{NULL}, no box is drawn}

\item{bar_wd_pct}{numeric; width of the color bar, as a fraction (0 to 1) of
the width of the \emph{legend area} (\strong{not} the entire right margin
width)}

\item{bar_ht_pct}{numeric; height of the color bar, as a fraction (0 to 1) of
the height of the \emph{legend area} (\strong{not} the entire right margin
height)}

\item{ticks}{numeric vector; the z-values at which to place tick marks. If
\code{NULL} (the default), tick placement is automatically calculated}

\item{ticks_n}{integer; the number of ticks desired - only used if
\code{ticks} is \code{NULL}. Note that this is an \emph{approximate} number
- the \code{\link[base:pretty]{pretty()}} function is used to generate
"nice-looking" values, but it doesn't guarantee a set number of tick marks}

\item{ticks_x_pct}{numeric; the x-placement of the tick labels as a fraction
(0 to 1) of the width of the legend area. This corresponds to the
\emph{right-most} part of the text - i.e. a value of 1 means the text will
end exactly at the right border of the legend area}
}
\value{
no return value
}
\description{
Adds a gradient legend to a plot.
}
\details{
I took an HTML/CSS-like approach to determining the positioning -
  that is, each space is treated as \code{<div>}-like space, and the position
  of objects within that space happens \emph{relative to that space} rather
  than the entire space. The parameters prefixed by \code{lgd} are all
  relative to the right margin space and correspond to the box that contains
  the entire legend. The parameters prefixed by \code{bar} and \code{ticks}
  are relative to the space within the legend box.

  This function is used within \code{\link[=plot.Quadtree]{plot}()}, so the
  user shouldn't call this function to manually create the legend.
  Customizations to the legend can be done via the \code{legend_args}
  parameter of \code{\link[=plot.Quadtree]{plot}()}. Using this function to
  plot the legend after using \code{\link[=plot.Quadtree]{plot}()} raises the
  possibility of the legend not corresponding correctly with the plot, and
  thus should be avoided.
}
\examples{
library(quadtree)
data(habitat)
qt <- quadtree(habitat, .2)

old_par <- par(mar = c(5, 4, 4, 5))
plot(qt, legend = FALSE)
add_legend(raster::cellStats(habitat, "range"), rev(terrain.colors(100)))
par(old_par)
# this example simply illustrates how it COULD be used, but as stated in the
# 'Details' section, it shouldn't be called separately from 'plot()' - if
# customizations to the legend are desired, use the 'legend_args' parameter
# of 'plot()'.
}
