% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CppQuadtree-class.R
\name{CppQuadtree-class}
\alias{CppQuadtree-class}
\alias{Rcpp_CppQuadtree}
\alias{Rcpp_CppQuadtree-class}
\alias{CppQuadtree}
\title{\code{CppQuadtree}: C++ quadtree data structure}
\description{
The \code{CppQuadtree} class is the underlying C++ data structure used by
  the \code{\link{Quadtree}} S4 class. Note that the average user should not
  need to use these functions - there are R wrapper functions that provide
  access to the many of the member functions.
}
\details{
This class is defined in 'src/QuadtreeWrapper.h' and
  'src/QuadtreeWrapper.cpp'. When made available to R, it is exposed as
  \code{CppQuadtree} rather than \code{QuadtreeWrapper}.
  \code{QuadtreeWrapper} contains a pointer to a \code{Quadtree} C++ object
  (defined in 'src/Quadtree.h' and 'src/Quadtree.cpp'). All of the core
  functionality is in the \code{Quadtree} C++ class - \code{QuadtreeWrapper}
  is a wrapper class that adds the 'Rcpp' code required for it to be
  accessible from R.
}
\section{Fields}{

\describe{
\item{\code{constructor}}{\itemize{
  \item \strong{Description}: Default constructor. Can be used as follows:
  \code{qt <- new(CppQuadtree)}
  \item \strong{Parameters}: none
  \item \strong{Returns}: an empty \code{CppQuadtree} object
}}

\item{\code{constructor}}{\itemize{
  \item \strong{Description}: Constructor. Can be used as follows: \code{qt
  <- new(CppQuadtree, xlims, ylims, maxCellLength, minCellLength,
  splitAllNAs, splitAnyNAs)}. Used in \code{\link{quadtree}()}. The
  parameters for this constructor correspond with the similarly named
  parameters in \code{\link{quadtree}()} - see its documentation for more
  details on what the parameters signify. Note that the constructor does not
  "build" the quadtree structure - that is done by \code{createTree()}.
  \item \strong{Parameters}: \itemize{
    \item \code{xlims}: two-element numeric vector (xmin, xmax)
    \item \code{ylims}: two-element numeric vector (ymin, ymax)
    \item \code{maxCellLength}: two-element numeric vector - first element is
    for the x dimension, second is for the y dimension
    \item \code{minCellLength}: two-element numeric vector - first element is
    for the x dimension, second is for the y dimension
    \item \code{splitAllNAs}: boolean
    \item \code{splitAnyNAs}: boolean
  }
}}

\item{\code{readQuadtree}}{\itemize{
  \item \strong{Description}: Reads a quadtree from a file. Note that this is
  a static function, so it does not require an instance of \code{CppQuadtree}
  to be called. \code{\link{read_quadtree}()} is a wrapper for this function
  - see its documentation for more details.
  \item \strong{Parameters}: \itemize{
    \item \code{filePath}: string; the file to read from
  }
  \item \strong{Returns}: a \code{CppQuadtree}
}}

\item{\code{asList}}{\itemize{
  \item \strong{Description}: Outputs a list containing details about
  each cell. \code{\link{as_data_frame}()} is a wrapper for this function
  that \code{rbind}s the individual list elements into a data frame.
  \item \strong{Parameters}: none
  \item \strong{Returns}: a list of named numeric vectors. Each
  numeric vector provides information on a single cell. The elements returned
  are the same as the columns described in the documentation for
  \code{\link{as_data_frame}()} - see that help page for details.
}}

\item{\code{asVector}}{\itemize{
  \item \strong{Description}: Returns cell values as a vector.
  \code{\link{as_vector}()} is a wrapper for this function.
  \item \strong{Parameters}: \itemize{
    \item \code{terminalOnly}: boolean; if \code{TRUE}, returns only the
    values of the terminal cells. If \code{FALSE}, returns all cell values
  }
  \item \strong{Returns}: a numeric vector
}}

\item{\code{copy}}{\itemize{
  \item \strong{Description}: Returns a deep copy of a quadtree.
  \code{\link{copy}()} is a wrapper for this function - see the
  documentation for that function for more details.
  \item \strong{Parameters}: none
  \item \strong{Returns}: a \code{CppQuadtree} object
}}

\item{\code{createTree}}{\itemize{
  \item \strong{Description}: Constructs a quadtree from a matrix.
  \code{\link{quadtree}()} is a wrapper for this function and should be used
  to create quadtrees. The parameters correspond with the similarly
  named parameters in \code{\link{quadtree}()} - see the
  documentation of that function for details on the parameters.
  \item \strong{Parameters}: \itemize{
    \item \code{mat}: matrix; data to be used to create the quadtree
    \item \code{splitMethod}: string
    \item \code{splitThreshold}: double
    \item \code{splitFun}: function
    \item \code{splitArgs}: list
    \item \code{combineFun}: function
    \item \code{combineArgs}: list
    \item \code{templateQuadtree}: \code{CppQuadtree} object
  }
  \item \strong{Returns}: void - no return value
}}

\item{\code{extent}}{\itemize{
  \item \strong{Description}: Returns the extent of the quadtree. This is
  equivalent to \code{\link{extent}(qt, original = FALSE)}
  \item \strong{Parameters}: none
  \item \strong{Returns}: four-element numeric vector, in this order: xmin,
  xmax, ymin, ymax
}}

\item{\code{getCell}}{\itemize{
  \item \strong{Description}: Given the x and y coordinates of a point,
  returns the cell at that point.
  \item \strong{Parameters}: \itemize{
    \item \code{pt}: two-element numeric vector (x,y)
  }
  \item \strong{Returns}: a \code{\link{CppNode}} object representing the
  cell that contains the point
}}

\item{\code{getCells}}{\itemize{
  \item \strong{Description}: Given x and y coordinates of points, returns a
  list of the cells at those points (as \code{\link{CppNode}} objects). It is
  the same as \code{getCell}, except that it allows users to get multiple
  cells at once instead of one at a time.
  \item \strong{Parameters}: \itemize{
    \item \code{x}: numeric vector; the x coordinates
    \item \code{y}: numeric vector; the y coordinates; must be the same
    length as \code{x}
  }
  \item \strong{Returns}: a list of \code{\link{CppNode}} objects
  corresponding to the x and y coordinates passed to the function
}}

\item{\code{getCellsDetails}}{\itemize{
  \item \strong{Description}: Given points defined by their x and y
  coordinates, returns a matrix giving details on the cells at each of the
  points.
  \code{\link{extract}(qt, extents = TRUE)} is a wrapper for this function.
  \item \strong{Parameters}: \itemize{
    \item \code{x}: numeric vector; the x coordinates
    \item \code{y}: numeric vector; the y coordinates; must be the same
    length as x
  }
  \item \strong{Returns}: A matrix with the cell details. See
  \code{\link{extract}()} for details about the matrix columns
}}

\item{\code{getLcpFinder}}{\itemize{
  \item \strong{Description}: Returns a \code{\link{CppLcpFinder}} object
  that can be used to find least-cost paths on the quadtree.
  \code{\link{lcp_finder}()} is a wrapper for this function. For details on
  the parameters see the documentation of the similarly named parameters in
  \code{\link{lcp_finder}()}.
  \item \strong{Parameters}: \itemize{
    \item \code{startPoint}: two-element numeric vector
    \item \code{xlim}: two-element numeric vector
    \item \code{ylim}: two-element numeric vector
    \item \code{searchByCentroid} : boolean
  }
  \item \strong{Returns}: a \code{\link{CppLcpFinder}} object
}}

\item{\code{getNeighborList}}{\itemize{
  \item \strong{Description}: Returns the neighbor relationships between all
  cells.
  \item \strong{Parameters}: none
  \item \strong{Returns}: a list of matrices. Each matrix corresponds to
  a single cell and has one line for each neighboring cell. "neighbor"
  includes diagonal adjacency. Each matrix has the following columns:
  \itemize{
    \item \code{id0}, \code{x0}, \code{y0}, \code{val0}, \code{hasChildren0}:
    the ID, x and y coordinates of the centroid, cell value, and whether the
    cell has children. This is for the cell of interest. Note that the values
    of these columns will be same across all rows because they refer to the
    same cell.
    \item \code{id1}, \code{x1}, \code{y1}, \code{val1}, \code{hasChildren1}:
    the ID, x and y coordinates of the centroid, cell value, and whether the
    cell has children. This is for the neighbors of the cell of interest.
    (i.e. the cell represented by the columns suffixed with '0').
  }
}}

\item{\code{getNeighbors}}{\itemize{
  \item \strong{Description}: Given a point, returns a matrix with info on
  the cells that neighbor the cell that the point falls in.
  \code{\link{get_neighbors}()} is a wrapper for this function.
  \item \strong{Parameters}: \itemize{
    \item \code{pt}: two-element numeric vector (x,y)
  }
  \item \strong{Returns}: a six-column matrix with one row per neighboring
  cell. It has the following columns: \itemize{
    \item \code{id}
    \item \code{xmin}
    \item \code{xmax}
    \item \code{ymin}
    \item \code{ymax}
    \item \code{value}
  }
}}

\item{\code{getValues}}{\itemize{
  \item \strong{Description}: Given points defined by their x and y
  coordinates, returns a numeric vector of the values of the cells at each of
  the points.
  \code{\link{extract}(qt, extents = FALSE)} is a wrapper for this function.
  \item \strong{Parameters}: \itemize{
    \item \code{x}: numeric vector; the x coordinates
    \item \code{y}: numeric vector; the y coordinates; must be the same
    length as \code{x}
  }
  \item \strong{Returns}: a numeric vector of cell values corresponding with
  the x and y coordinates passed to the function
}}

\item{\code{maxCellDims}}{\itemize{
  \item \strong{Description}: Returns the maximum allowable cell length used
  when constructing the quadtree (i.e. the value passed to the
  \code{max_cell_length} parameter of \code{\link{quadtree}()}). Note that
  this does \strong{not} return the maximum cell size in the quadtree - it
  returns the maximum \emph{allowable} cell size. Also note that if no value
  was provided for \code{max_cell_length}, the max allowable cell length is
  set to the length and width of the total extent.
  \item \strong{Parameters}: none
  \item \strong{Returns}: A two-element numeric vector giving the maximum
  allowable side length for the x and y dimensions.
}}

\item{\code{minCellDims}}{\itemize{
  \item \strong{Description}: Returns the minimum allowable cell length used
  when constructing the quadtree (i.e. the value passed to the
  \code{min_cell_length} parameter of \code{\link{quadtree}()}). Note that
  this does \strong{not} return the minimum cell size in the quadtree - it
  returns the minimum \emph{allowable} cell size. Also note that if no value
  was provided for \code{min_cell_length}, the min allowable cell length is
  set to -1.
  \item \strong{Parameters}: none
  \item \strong{Returns}: A two-element numeric vector giving the minimum
  allowable side length for the x and y dimensions.
}}

\item{\code{nNodes}}{\itemize{
  \item \strong{Description}: Returns the total number of nodes in the
  quadtree. Note that this includes \emph{all} nodes, not just terminal
  nodes.
  \item \strong{Parameters}: none
  \item \strong{Returns}: integer
}}

\item{\code{originalDim}}{\itemize{
  \item \strong{Description}: Returns the dimensions of the raster used to
  create the quadtree \emph{before} its dimensions were adjusted.
  \item \strong{Parameters}: none
  \item \strong{Returns}: two-element numeric vector that gives the number of
  cells along the x and y dimensions.
}}

\item{\code{originalExtent}}{\itemize{
  \item \strong{Description}: Returns the extent of the raster used to create
  the quadtree \emph{before} its dimensions/extent were adjusted. This is
  equivalent to \code{\link{extent}(qt, original = TRUE)}
  \item \strong{Parameters}: none
  \item \strong{Returns}: four-element numeric vector, in this order: xmin,
  xmax, ymin, ymax
}}

\item{\code{originalRes}}{\itemize{
  \item \strong{Description}: Returns the resolution of the raster used to
  create the quadtree \emph{before} its dimensions/extent were adjusted.
  \item \strong{Parameters}: none
  \item \strong{Returns}: two-element numeric vector (x cell length, y cell
  length)
}}

\item{\code{print}}{\itemize{
  \item \strong{Description}: Returns a string that represents the quadtree.
  \item \strong{Parameters}: none
  \item \strong{Returns}: a string
}}

\item{\code{projection}}{\itemize{
  \item \strong{Description}: Returns the proj4string of the quadtree.
  \item \strong{Parameters}: none
  \item \strong{Returns}: a string
}}

\item{\code{root}}{\itemize{
  \item \strong{Description}: Returns the root node of the quadtree.
  \item \strong{Parameters}: none
  \item \strong{Returns}: a \code{\link{CppNode}} object
}}

\item{\code{setOriginalValues}}{\itemize{
  \item \strong{Description}: Sets the properties that record the extent and
  dimensions of the original raster used to create the quadtree
  \item \strong{Parameters}: \itemize{
    \item \code{xmin}: double
    \item \code{xmax}: double
    \item \code{ymin}: double
    \item \code{ymax}: double
    \item \code{nX}: integer - number of cells along the x dimension
    \item \code{nY}: integer - number of cells along the y dimension
  }
  \item \strong{Returns}: void - no return value
}}

\item{\code{setProjection}}{\itemize{
  \item \strong{Description}: Sets the the proj4string of the quadtree.
  \item \strong{Parameters}: \itemize{
    \item \code{proj4string}: string
  }
  \item \strong{Returns}: void - no return value
}}

\item{\code{setValues}}{\itemize{
  \item \strong{Description}: Given points defined by their x and y
  coordinates and a vector of values, sets the values of the quadtree cells
  at each of the points. \code{\link{set_values}()} is a wrapper for this
  function - see its documentation page for more details.
  \item \strong{Parameters}: \itemize{
    \item \code{x}: numeric vector; the x coordinates
    \item \code{y}: numeric vector; the y coordinates; must be the same
    length as x
    \item \code{newVals}: numeric vector; must be the same length as x and y
  }
  \item \strong{Returns}: void - no return value
}}

\item{\code{transformValues}}{\itemize{
  \item \strong{Description}: Uses a function to transform the values of all
  cells. \code{\link{transform_values}()} is a wrapper for this function -
  see its documentation page for more details.
  \item \strong{Parameters}: \itemize{
    \item \code{trasform_fun}: function
  }
  \item \strong{Returns}: void - no return value
}}

\item{\code{writeQuadtree}}{\itemize{
  \item \strong{Description}: Writes a quadtree to a file.
  \code{\link{write_quadtree}()} is a wrapper for this function - see its
  documentation page for more details.
  \item \strong{Parameters}: \itemize{
    \item \code{filePath}: string; the file to save the quadtree to
  }
  \item \strong{Returns}: void - no return value
}}
}}

