% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSurvey.R
\name{getSurvey}
\alias{getSurvey}
\title{Export a survey and download into R}
\usage{
getSurvey(surveyID, headers,
  base_url = "https://yourdatacenterid.qualtrics.com/API/v3/responseexports/",
  verbose = FALSE)
}
\arguments{
\item{surveyID}{Unique ID for the survey you want to download. Returned as 'id' by the \link[qualtRics]{getSurveys} function.}

\item{headers}{'headers' object - returned by the 'constructHeader' function. See \link[qualtRics]{constructHeader}.}

\item{base_url}{Base url for your institution (see \url{https://api.qualtrics.com/docs/csv}. If you do not fill in anything, the function will use the default url. Using your institution-specific url can significantly speed up queries.)}

\item{verbose}{Print verbose messages to the R console? Defaults to FALSE}
}
\description{
Export a qualtrics survey you own and import the survey directly into R. NOTE: If you keep getting errors try to use your institution's base URL. See \url{https://api.qualtrics.com/docs/root-url}.
}
\examples{
\dontrun{
head <- constructHeader("<YOUR-API-KEY-HERE>")
surveys <- getSurveys(head,
                      "https://leidenuniv.eu.qualtrics.com/API/v3/responseexports/")
                      # URL is for my own institution.
                      # Substitute with your own institution's url
mysurvey <- getSurvey(surveys$id[6],
                      head,
                      "https://leidenuniv.eu.qualtrics.com/API/v3/responseexports/",
                      verbose=TRUE)
}
}
\author{
Jasper Ginn
}
\seealso{
See \url{https://api.qualtrics.com/docs/csv} for documentation on the Qualtrics API.
}

