% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registerApiKey.R
\name{registerApiKey}
\alias{registerApiKey}
\title{Register qualtrics API key}
\usage{
registerApiKey(API.TOKEN)
}
\arguments{
\item{API.TOKEN}{API token. Available in your qualtrics account (see: \url{https://api.qualtrics.com/docs/authentication})}
}
\description{
This function registers the user's qualtrics API key for the remainder of the R session. This function only needs to be called once (at the beginning of each R session).
}
\examples{
\dontrun{
registerApiKey("<YOUR-QUALTRICS-API-KEY>")
surveys <- getSurveys("https://leidenuniv.eu.qualtrics.com")
                      # URL is for my own institution.
                      # Substitute with your own institution's url
mysurvey <- getSurvey(surveys$id[6],
                      format = "csv",
                      save_dir = tempdir(),
                      "https://leidenuniv.eu.qualtrics.com",
                      verbose=TRUE)
}

}
\seealso{
See \url{https://api.qualtrics.com/docs/root-url} for documentation on the Qualtrics API.
}
\author{
Jasper Ginn
}
