% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSurveyQuestions.R
\name{getSurveyQuestions}
\alias{getSurveyQuestions}
\title{Retrieve a data frame containing question IDs and labels}
\usage{
getSurveyQuestions(surveyID)
}
\arguments{
\item{surveyID}{String. Unique ID for the survey you want to download. Returned as 'id' by the \link[qualtRics]{getSurveys} function.}
}
\description{
Retrieve a data frame containing question IDs and labels
}
\examples{
\dontrun{
# Register your Qualtrics credentials if you haven't already
registerOptions(api_token="<YOUR-API-TOKEN>", root_url="<YOUR-ROOT-URL>")
# Retrieve a list of surveys
surveys <- getSurveys()
# Retrieve questions for a survey
questions <- getSurveyQuestions(surveyID = surveys$id[6])
# Retrieve a single survey, filtering for questions I want.
mysurvey <- getSurvey(surveyID = surveys$id[6],
                      save_dir = tempdir(),
                      includedQuestionIds = c("QID1", "QID2", "QID3"),
                      verbose=TRUE)
}
}
\seealso{
See \url{https://api.qualtrics.com/docs} for documentation on the Qualtrics API.
}
\author{
Jasper Ginn
}
