% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multigroupVolcano.R
\name{multigroupVolcano}
\alias{multigroupVolcano}
\title{plot volcano given multiple conditions}
\usage{
multigroupVolcano(misspX, effect = "fc", type = "p.adjust",
  condition = "condition", colour = "colour", xintercept = c(-2, 2),
  pvalue = 0.05, label = NULL, size = 1, segment.size = 0.3,
  segment.alpha = 0.3, ablines = data.frame(fc = c(0, 0), p = c(0.01, 0.05),
  Area = c("p=0.01", "p=0.05")))
}
\arguments{
\item{misspX}{data in long format}

\item{effect}{column containing effect sizes}

\item{type}{column containing p-values, q.values etc}

\item{condition}{column with condition}

\item{colour}{colouring of points}

\item{xintercept}{fc thresholds}

\item{pvalue}{pvalue threshold}

\item{label}{column containing labels}

\item{size}{controls size of text}

\item{segment.size}{controls size of lines}

\item{segment.alpha}{controls visibility of lines}

\item{ablines}{adds ablines horizontal and vertical}
}
\description{
plot volcano given multiple conditions
}
\examples{
data(multigroupFCDATA)
colnames(multigroupFCDATA)
multigroupVolcano(multigroupFCDATA,effect="logFC",
type="adj.P.Val",condition="Condition",colour="colour",label="Name" )
}
