% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textstat_summary.R
\name{textstat_summary}
\alias{textstat_summary}
\title{Summarize documents as syntactic and lexical feature counts}
\usage{
textstat_summary(x, ...)
}
\arguments{
\item{x}{corpus to be summarized}

\item{...}{additional arguments passed through to \link[quanteda:dfm]{dfm()}}
}
\description{
Count syntactic and lexical features of documents such as tokens, types,
sentences, and character categories.
}
\details{
Count the total number of characters, tokens and sentences as well as special
tokens such as numbers, punctuation marks, symbols, tags and emojis.
\itemize{
\item chars = number of characters; equal to \code{\link[=nchar]{nchar()}}
\item sents
= number of sentences; equal \code{ntoken(tokens(x), what = "sentence")}
\item
tokens = number of tokens; equal to \link[quanteda:ntoken]{ntoken()}
\item types = number of unique tokens; equal to \link[quanteda:ntoken]{ntype()}
\item puncts = number of punctuation marks (\verb{^\\p\{P\}+$})
\item numbers = number of numeric tokens
(\verb{^\\p\{Sc\}\{0,1\}\\p\{N\}+([.,]*\\p\{N\})*\\p\{Sc\}\{0,1\}$})
\item symbols = number of symbols (\verb{^\\p\{S\}$})
\item tags = number of tags; sum of \code{pattern_username} and \code{pattern_hashtag}
in \code{\link[quanteda:quanteda_options]{quanteda::quanteda_options()}}
\item emojis = number of emojis (\verb{^\\p\{Emoji_Presentation\}+$})
}
}
\examples{
if (Sys.info()["sysname"] != "SunOS") {
library("quanteda")
corp <- data_corpus_inaugural[1:5]
textstat_summary(corp)
toks <- tokens(corp)
textstat_summary(toks)
dfmat <- dfm(toks)
textstat_summary(dfmat)
}
}
\keyword{textstat}
