% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/textmodel-generics.R
\docType{methods}
\name{textmodel}
\alias{textmodel}
\alias{textmodel,dfm,ANY,missing,character-method}
\alias{textmodel,formula,missing,dfm,character-method}
\title{fit a text model}
\usage{
textmodel(x, y = NULL, data = NULL, model = c("wordscores", "NB",
  "wordfish", "lda", "ca"), ...)

\S4method{textmodel}{dfm,ANY,missing,character}(x, y = NULL, data = NULL,
  model = c("wordscores", "NB", "wordfish", "lda", "ca"), ...)

\S4method{textmodel}{formula,missing,dfm,character}(x, y = NULL,
  data = NULL, model = c("wordscores", "NB", "wordfish", "lda", "ca"), ...)
}
\arguments{
\item{x}{a quanteda \link{dfm} object containing feature counts by document}

\item{y}{for supervised models, a vector of class labels or values for
training the model, with \code{NA} for documents to be excluded from the
training set; for unsupervised models, this will be left NULL}

\item{data}{dfm or data.frame from which to take the formula}

\item{model}{the model type to be fit.  Currently implemented methods are:
  \describe{ \item{\code{wordscores}}{Fits the "wordscores" model of Laver,
  Benoit, and Garry (2003). Options include the original linear scale of LBG
  or the logit scale proposed by Beauchamps (2001).  See
  \link{textmodel_wordscores}.}

  \item{\code{ca}}{Correspondence analysis scaling of the dfm.}

  \item{\code{NB}}{Fits a Naive Bayes model to the dfm, with options for
  smoothing, setting class priors, and a choice of multinomial or binomial
  probabilities.}

  \item{\code{wordfish}}{Fits the "wordfish" model of Slapin and Proksch (2008).}

  \item{\code{lda}}{Fit a topic model based on latent Dirichlet allocation.  Temporarily removed.}

  \item{\code{kNN}}{k-nearest neighbour classification, coming soon.}
  }}

\item{...}{additional arguments to be passed to specific model types}

\item{formula}{An object of class \link{formula} of the form \code{y ~ x1
+ x2 + ...}.  (Interactions are not currently allowed for any of the models
implemented.)  The \code{x} variable(s) is
typically a \link{dfm}, and the y variable a vector of class labels or
training values associated with each document.}
}
\value{
a \code{textmodel} class list, containing the fitted model and
  additional information specific to the model class.  See the methods for
  specific models, e.g. \link{textmodel_wordscores},
  etc.
}
\description{
Fit a text model to a dfm.  Creates an object of virtual class
\link{textmodel_fitted-class}, whose exact properties (slots and methods)
will depend on which model was called (see \code{model} types below).
}
\section{Class hierarchy}{
 Here will go the description of the class hierarchy
  that governs dispatch for the predict, print, summary methods, since this
  is not terribly obvious. (Blame it on the S3 system.)
}
\examples{
ieDfm <- dfm(ie2010Corpus, verbose=FALSE)
refscores <- c(rep(NA, 4), -1, 1, rep(NA, 8))
ws <- textmodel(ieDfm, refscores, model="wordscores", smooth=1)

# alternative formula notation - but slower
# need the - 1 to remove the intercept, as this is literal formula notation
wsform <- textmodel(refscores ~ . - 1, data=ieDfm, model="wordscores", smooth=1)
identical(ws@Sw, wsform@Sw)  # compare wordscores from the two models


# compare the logit and linear wordscores
bs <- textmodel(ieDfm[5:6,], refscores[5:6], model="wordscores", scale="logit", smooth=1)
plot(ws@Sw, bs@Sw, xlim=c(-1, 1), xlab="Linear word score", ylab="Logit word score")

\donttest{wf <- textmodel(ieDfm, model="wordfish", dir = c(6,5))
wf}
}
\seealso{
\code{\link{textmodel}}, \code{\link{textmodel_wordscores}}
}

