% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stopwords.R
\name{removeFeatures}
\alias{removeFeatures}
\alias{removeFeatures.collocations}
\alias{removeFeatures.dfm}
\alias{stopwordsRemove}
\title{remove features from an object}
\usage{
removeFeatures(x, stopwords = NULL, verbose = TRUE, ...)

\method{removeFeatures}{dfm}(x, stopwords = NULL, verbose = TRUE, ...)

\method{removeFeatures}{collocations}(x, stopwords = NULL, verbose = TRUE,
  pos = c(1, 2, 3), ...)

stopwordsRemove(x, stopwords = NULL, verbose = TRUE)
}
\arguments{
\item{x}{object from which stopwords will be removed}

\item{stopwords}{character vector of features to remove.  Now requires an explicit
list to be supplied, for instance \code{stopwords("english")}.}

\item{verbose}{if \code{TRUE} print message about how many features were removed}

\item{...}{additional arguments for some methods (such as \code{pos} for \link{collocations})}

\item{pos}{indexes of word position if called on collocations: remove if word \code{pos}
is a stopword}
}
\value{
an object with stopwords removed
}
\description{
This function removes features from a variety of objects, such as text, a dfm, or
a list of collocations.  The most common usage for \code{removeFeatures} will be
to eliminate stop words from a text or text-based object.  Some commonly used
built-in stop words can be accessed through \code{\link{stopwords}}.
}
\details{
Because we believe the user should take full responsibility for any features
that are removed, we do not provide a default list.  Use \code{\link{stopwords}} instead.
}
\examples{
## examples for character objects
someText <- tokenize(c(text1 = "Here's some text containing words we want to remove."))
removeFeatures(someText, stopwords("english"))
removeFeatures(someText, stopwords("SMART"))
removeFeatures(someText, c("some", "want"))
someText <- tokenize(c(text1 = "Here's some text containing words we want to remove.",
                       text2 = "A second sentence with a few stopwords."))
removeFeatures(someText, stopwords("english"))

## for tokenized texts
txt <- c(wash1 <- "Fellow citizens, I am again called upon by the voice of my country to
                   execute the functions of its Chief Magistrate.",
         wash2 <- "When the occasion proper for it shall arrive, I shall endeavor to express
                   the high sense I entertain of this distinguished honor.")
removeFeatures(tokenize(txt), stopwords("english"))

itText <- tokenize("Ecco alcuni di testo contenente le parole che vogliamo rimuovere.",
                   removePunct = TRUE)
removeFeatures(itText, stopwords("italian"), case_insensitive = TRUE)

## example for dfm objects
mydfm <- dfm(ukimmigTexts, verbose=FALSE)
removeFeatures(mydfm, stopwords("english"))

## example for collocations
(myCollocs <- collocations(inaugTexts[1:3], top=20))
removeFeatures(myCollocs, stopwords("english", verbose=FALSE))
}
\author{
Kenneth Benoit
}
\seealso{
\link{stopwords}
}

