% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-methods.R
\name{cbind.dfm}
\alias{cbind.dfm}
\title{combine dfm object by columns}
\usage{
cbind.dfm(x, y, ...)
}
\arguments{
\item{x}{a \link{dfm} object}

\item{y}{a second \link{dfm} object to be joined column-wise to the first}

\item{...}{optional arguments for methods}
}
\value{
A dfm object with combined features from input dfm objects.  The attributes of this
new dfm are not currently preserved.
}
\description{
Combine two or more dfm objects by columns.  An implementation of
\code{\link{cbind}} for \link{dfm} objects. Calls \code{\link{cbind2}}
defined for object classes in the \pkg{Matrix} package.
}
\examples{
dfm1 <- dfm("This is a sample text.", verbose = FALSE)
dfm2 <- dfm("one two three", verbose = FALSE)
cbind(dfm1, dfm2)
}

