% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{changeunits}
\alias{changeunits}
\alias{changeunits.corpus}
\title{change the document units of a corpus}
\usage{
changeunits(x, ...)

\method{changeunits}{corpus}(x, to = c("sentences", "paragraphs",
  "documents"), ...)
}
\arguments{
\item{x}{corpus whose document units will be reshaped}

\item{...}{not used}

\item{to}{new documents units for the corpus to be recast in}
}
\value{
A corpus object with the documents defined as the new units, including document-level meta-data identifying the original documents.
}
\description{
For a corpus, recast the documents down or up a level of aggregation.  "Down"
would mean going from documents to sentences, for instance.  "Up" means from 
sentences back to documents.  This makes it easy to reshape a corpus from a 
collection of documents into a collection of sentences, for instance.
}
\examples{
# simple example
mycorpus <- corpus(c(textone = "This is a sentence.  Another sentence.  Yet another.", 
                     textwo = "Premiere phrase.  Deuxieme phrase."), 
                   docvars = data.frame(country=c("UK", "USA"), year=c(1990, 2000)),
                   notes = "This is a simple example to show how changeunits() works.")
summary(mycorpus)
summary(changeunits(mycorpus, to = "sentences"), showmeta=TRUE)

# example with inaugural corpus speeches
(mycorpus2 <- subset(inaugCorpus, Year>2004))
paragCorpus <- changeunits(mycorpus2, to="paragraphs")
paragCorpus
summary(paragCorpus, 100, showmeta=TRUE)
## Note that Bush 2005 is recorded as a single paragraph because that text used a single
## \\n to mark the end of a paragraph.
}

