% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel-internal.R, R/textmodel-wordfish.R,
%   R/textmodel-wordscores.R, R/textmodel-wordshoal.R
\docType{class}
\name{textmodel-internal}
\alias{textmodel-internal}
\alias{textmodel_wordfish_fitted-class}
\alias{textmodel_wordfish_predicted-class}
\alias{print.textmodel_wordfish_fitted}
\alias{show,textmodel_wordfish_fitted-method}
\alias{show,textmodel_wordfish_predicted-method}
\alias{textmodel_wordscores_fitted-class}
\alias{textmodel_wordscores_predicted-class}
\alias{predict.textmodel_wordscores_fitted}
\alias{print.textmodel_wordscores_fitted}
\alias{show,textmodel_wordscores_fitted-method}
\alias{show,textmodel_wordscores_predicted-method}
\alias{print.textmodel_wordshoal_fitted}
\alias{show,textmodel_wordshoal_fitted-method}
\alias{show,textmodel_wordshoal_predicted-method}
\title{internal functions for textmodel objects}
\usage{
\method{print}{textmodel_wordfish_fitted}(x, n = 30L, ...)

\S4method{show}{textmodel_wordfish_fitted}(object)

\S4method{show}{textmodel_wordfish_predicted}(object)

\method{predict}{textmodel_wordscores_fitted}(object, newdata = NULL,
  rescaling = "none", level = 0.95, verbose = TRUE, ...)

\method{print}{textmodel_wordscores_fitted}(x, n = 30L, digits = 2, ...)

\S4method{show}{textmodel_wordscores_fitted}(object)

\S4method{show}{textmodel_wordscores_predicted}(object)

\method{print}{textmodel_wordshoal_fitted}(x, ...)

\S4method{show}{textmodel_wordshoal_fitted}(object)

\S4method{show}{textmodel_wordshoal_predicted}(object)
}
\arguments{
\item{x}{for print method, the object to be printed}

\item{n}{max rows of dfm to print}

\item{...}{additional arguments passed to \code{\link{print}}}

\item{object}{wordfish fitted or predicted object to be shown}

\item{newdata}{dfm on which prediction should be made}

\item{rescaling}{\code{none} for "raw" scores; \code{lbg} for LBG (2003) 
rescaling; or \code{mv} for the rescaling proposed by Martin and Vanberg 
(2007).  (Note to authors: Provide full details here in documentation.)}

\item{level}{probability level for confidence interval width}

\item{verbose}{If \code{TRUE}, output status messages}

\item{digits}{number of decimal places to print for print methods}

\item{object}{a fitted Wordscores textmodel}

\item{...}{additional arguments passed to other functions}

\item{x}{for print method, the object to be printed}

\item{n}{max rows of dfm to print}

\item{x}{for print method, the object to be printed}

\item{...}{additional arguments passed to \code{\link{print}}}
}
\value{
The \code{predict} method for a wordscores fitted object returns a 
  data.frame whose rows are the documents fitted and whose columns contain 
  the scored textvalues, with the number of columns depending on the options 
  called (for instance, how many rescaled scores, and whether standard errors
  were requested.)  (Note: We may very well change this soon so that it is a 
  list similar to other existing fitted objects.)
}
\description{
Internal function documentation for textmodel objects.
}
\references{
Laver, Michael, Kenneth R Benoit, and John Garry. 2003. 
"Extracting Policy Positions From Political Texts Using Words as Data." 
\emph{American Political Science Review} 97(02): 311-31.

Martin, L W, and G Vanberg. 2007. "A Robust Transformation Procedure for
Interpreting Political Text." \emph{Political Analysis} 16(1): 93-100.
}
\keyword{internal}
\keyword{textmodel}
