% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textstat_collocations.R, R/tokens.R
\name{as.tokens.collocations}
\alias{as.tokens.collocations}
\alias{as.tokens}
\alias{as.tokens.list}
\alias{as.list.tokens}
\alias{as.character.tokens}
\alias{is.tokens}
\alias{+.tokens}
\alias{c.tokens}
\title{coercion and checking functions for tokens objects}
\usage{
\method{as.tokens}{collocations}(x)

as.tokens(x)

\method{as.tokens}{list}(x)

\method{as.list}{tokens}(x, ...)

\method{as.character}{tokens}(x, use.names = FALSE, ...)

is.tokens(x)

\method{+}{tokens}(t1, t2)

\method{c}{tokens}(..., recursive = FALSE)
}
\arguments{
\item{x}{list of character elements}

\item{...}{unused}

\item{use.names}{logical; preserve names if \code{TRUE}.  For
\code{as.character} only.}

\item{t1}{tokens one to be added}

\item{t2}{tokens two to be added}

\item{recursive}{logical used by `c()` method, always set to `FALSE`}
}
\value{
\code{as.tokens} returns a quanteda \link{tokens} object

\code{as.list} returns a simple list of characters from a
  \link{tokens} object

\code{as.character} returns a character vector from a 
  \link{tokens} object

\code{is.tokens} returns \code{TRUE} if the object is of class
  tokens, \code{FALSE} otherwise.
}
\description{
Coerce a list of character elements to a quanteda \link{tokens} object, or check whether 
an object is a \link{tokens} object.
}
\examples{
toks1 <- tokens(data_corpus_inaugural[1:5])
toks2 <- tokens(data_corpus_inaugural[21:25])
toks3 <- toks1 + toks2


toks1 <- tokens(data_corpus_inaugural[1:5])
toks2 <- tokens(data_corpus_inaugural[21:25])
toks3 <- tokens(data_corpus_inaugural[41:45])
summary(c(toks1, toks2, toks3))

}
