% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens.R
\name{tokens_hash}
\alias{tokens_hash}
\title{Function to hash list-of-character tokens}
\usage{
tokens_hash(x, types_reserved, ...)
}
\arguments{
\item{x}{a source of tokenizedText}

\item{...}{additional arguments}

\item{types}{optional pre-existing types for mapping of tokens}
}
\value{
a list the hashed tokens found in each text
}
\description{
Creates a hashed object of tokens, called by \code{\link{tokens}}.
}
\details{
This was formerly used to create a \code{tokenizedTextsHashed}
  object, but all tokens objects are now hashed, so this is just exported for
  testing until it will become internal only.
}
\note{
This will be internal only soon.
}
\examples{
txt <- c(doc1 = "The quick brown fox jumped over the lazy dog.",
         doc2 = "The dog jumped and ate the fox.")
toks <- tokenize(char_tolower(txt), remove_punct = TRUE)
toksHashed <- tokens_hash(toks)
toksHashed
# returned as a list
as.list(toksHashed)
# returned as a tokenized Text
as.tokenizedTexts(toksHashed)

# change case
toks <- tokens_hash(tokenize(c(one = "a b c d A B C D",
                                two = "A B C d")))

}
\seealso{
\code{\link{tokenize}}
}
\keyword{internal}
\keyword{tokens}
