% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens.R
\name{as.tokens}
\alias{as.tokens}
\alias{as.tokens.list}
\alias{as.tokens.collocations}
\alias{as.list.tokens}
\alias{unlist.tokens}
\alias{as.character.tokens}
\alias{is.tokens}
\alias{+.tokens}
\alias{c.tokens}
\title{coercion, checking, and combining functions for tokens objects}
\usage{
as.tokens(x)

\method{as.tokens}{list}(x)

\method{as.tokens}{collocations}(x)

\method{as.list}{tokens}(x, ...)

\method{unlist}{tokens}(x, recursive = FALSE, use.names = TRUE)

\method{as.character}{tokens}(x, use.names = FALSE, ...)

is.tokens(x)

\method{+}{tokens}(t1, t2)

\method{c}{tokens}(...)
}
\arguments{
\item{x}{object to be coerced or checked}

\item{...}{for \link{c.tokens} only, \link{tokens} objects to be concatenated}

\item{recursive}{a required argument for \link{unlist} but inapplicable to
\link{tokens} objects}

\item{use.names}{logical; preserve names if \code{TRUE}.  For
\code{as.character} and \code{unlist} only.}

\item{t1}{tokens one to be added}

\item{t2}{tokens two to be added}
}
\value{
\code{as.tokens} returns a quanteda \link{tokens} object

\code{as.list} returns a simple list of characters from a
  \link{tokens} object

\code{unlist} returns a simple vector of characters from a 
  \link{tokens} object

\code{as.character} returns a character vector from a 
  \link{tokens} object

\code{is.tokens} returns \code{TRUE} if the object is of class
  tokens, \code{FALSE} otherwise.

\code{c(...)} and \code{+} return a tokens object whose documents
  have been added as a single sequence of documents.
}
\description{
Coercion functions to and from \link{tokens} objects, checks for whether an
object is a \link{tokens} object, and functions to combine \link{tokens}
objects.
}
\examples{
# combining tokens
toks1 <- tokens(c("a b c d e", "f g h"))
toks2 <- tokens(c("1 2 3"))
toks1 + toks2
c(toks1, toks2)

}
