% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus_subset.R
\name{corpus_subset}
\alias{corpus_subset}
\title{extract a subset of a corpus}
\usage{
corpus_subset(x, subset, select, ...)
}
\arguments{
\item{x}{\link{corpus} object to be subsetted}

\item{subset}{logical expression indicating the documents to keep: missing
values are taken as false}

\item{select}{expression, indicating the docvars to select from the corpus}

\item{...}{not used}
}
\value{
corpus object, with a subset of documents (and docvars) selected according to arguments
}
\description{
Returns subsets of a corpus that meet certain conditions, including direct 
logical operations on docvars (document-level variables).  \code{corpus_subset}
functions identically to \code{\link{subset.data.frame}}, using non-standard
evaluation to evaluate conditions based on the \link{docvars} in the corpus.
}
\examples{
summary(corpus_subset(data_corpus_inaugural, Year > 1980))
summary(corpus_subset(data_corpus_inaugural, Year > 1930 & President == "Roosevelt", 
                      select = Year))
}
\seealso{
\code{\link{subset.data.frame}}
}
\keyword{corpus}
