% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_influence.R
\name{textplot_influence}
\alias{textplot_influence}
\title{Influence plot for text scaling models}
\usage{
textplot_influence(x, n = 30, ...)
}
\arguments{
\item{x}{the object output from `influence()` run on the 
fitted or predicted scaling model object to be plotted}

\item{n}{the number of features whose influence will be plotted}

\item{...}{additional arguments passed to \code{\link{plot}}}
}
\description{
Plot the results of a fitted scaling model, from (e.g.) a predicted 
\link{textmodel_affinity} model.
}
\examples{
af <- textmodel_affinity(data_dfm_lbgexample, y = c("L", NA, NA, NA, "R", NA))
afpred <- predict(af) 
textplot_influence(influence(afpred))
}
\seealso{
\code{\link{textmodel_affinity}}

\code{\link{influence.predict.textmodel_affinity}}
}
\author{
Patrick Perry and Kenneth Benoit
}
\keyword{textplot}
