% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcm-methods.R
\name{fcm_sort}
\alias{fcm_sort}
\title{Sort an fcm in alphabetical order of the features}
\usage{
fcm_sort(x)
}
\arguments{
\item{x}{\link{fcm} object}
}
\value{
A \link{fcm} object whose features have been alphabetically sorted. 
  Differs from \code{\link{fcm_sort}} in that this function sorts the fcm by
  the feature labels, not the counts of the features.
}
\description{
Sorts an \link{fcm} in alphabetical order of the features.
}
\examples{
# with tri = FALSE
fcmat1 <- fcm(tokens(c("A X Y C B A", "X Y C A B B")), tri = FALSE)
rownames(fcmat1)[3] <- colnames(fcmat1)[3] <- "Z"
fcmat1
fcm_sort(fcmat1)

# with tri = TRUE
fcmat2 <- fcm(tokens(c("A X Y C B A", "X Y C A B B")), tri = TRUE)
rownames(fcmat2)[3] <- colnames(fcmat2)[3] <- "Z"
fcmat2
fcm_sort(fcmat2)
}
\author{
Kenneth Benoit
}
