% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-print.R, R/fcm.R
\docType{methods}
\name{print.dfm}
\alias{print.dfm}
\alias{print,dfm-method}
\alias{show,dfm-method}
\alias{print,fcm-method}
\alias{show,fcm-method}
\alias{head.fcm}
\alias{tail.fcm}
\title{Print a dfm object}
\usage{
\S4method{print}{dfm}(x, show.values = NULL, show.settings = FALSE,
  show.summary = TRUE, ndoc = quanteda_options("print_dfm_max_ndoc"),
  nfeat = quanteda_options("print_dfm_max_nfeat"), ...)

\S4method{show}{dfm}(object)

\S4method{print}{fcm}(x, show.values = NULL, show.settings = FALSE,
  show.summary = TRUE, ndoc = quanteda_options("print_dfm_max_ndoc"),
  nfeature = quanteda_options("print_dfm_max_nfeat"), ...)

\S4method{show}{fcm}(object)

\method{head}{fcm}(x, n = 6L, nfeature = 6L, ...)

\method{tail}{fcm}(x, n = 6L, nfeature = 6L, ...)
}
\arguments{
\item{x}{the dfm to be printed}

\item{show.values}{print the dfm values; if called explicitly this will print
all values.}

\item{show.settings}{print the settings used to create the dfm. See 
\link{settings}.}

\item{show.summary}{print a brief summary indicating the number of documents 
and features}

\item{ndoc}{max number of documents to print; default is from the
\code{print_dfm_max_ndoc} setting of \code{\link{quanteda_options}}}

\item{nfeat}{max number of features to print; default is from the
\code{print_dfm_max_nfeat} setting of \code{\link{quanteda_options}}}

\item{...}{further arguments passed to \code{Matrix::printSpMatrix2}}

\item{object}{the item to be printed}
}
\description{
Print methods for document-feature matrices
}
\seealso{
\code{\link{quanteda_options}}
}
\keyword{dfm}
\keyword{internal}
