% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quanteda-documentation.R,
%   R/corpus-methods-base.R, R/dfm-print.R, R/dictionaries.R, R/fcm-print.R,
%   R/tokens-methods-base.R
\name{print-quanteda}
\alias{print-quanteda}
\alias{print.corpus}
\alias{print,dfm-method}
\alias{show,dfm-method}
\alias{print,dictionary2-method}
\alias{print.dictionary}
\alias{show,dictionary2-method}
\alias{print,fcm-method}
\alias{show,fcm-method}
\alias{print.tokens}
\title{Print methods for quanteda core objects}
\usage{
\method{print}{corpus}(
  x,
  max_ndoc = quanteda_options("print_corpus_max_ndoc"),
  max_nchar = quanteda_options("print_corpus_max_nchar"),
  show_summary = quanteda_options("print_corpus_summary"),
  ...
)

\S4method{print}{dfm}(
  x,
  max_ndoc = quanteda_options("print_dfm_max_ndoc"),
  max_nfeat = quanteda_options("print_dfm_max_nfeat"),
  show_summary = quanteda_options("print_dfm_summary"),
  ...
)

\S4method{show}{dfm}(object)

\S4method{print}{dictionary2}(
  x,
  max_nkey = quanteda_options("print_dictionary_max_nkey"),
  max_nval = quanteda_options("print_dictionary_max_nval"),
  show_summary = quanteda_options("print_dictionary_summary"),
  ...
)

\S4method{show}{dictionary2}(object)

\S4method{print}{fcm}(
  x,
  max_nfeat = quanteda_options("print_dfm_max_nfeat"),
  show_summary = TRUE,
  ...
)

\S4method{show}{fcm}(object)

\method{print}{tokens}(
  x,
  max_ndoc = quanteda_options("print_tokens_max_ndoc"),
  max_ntoken = quanteda_options("print_tokens_max_ntoken"),
  show_summary = quanteda_options("print_tokens_summary"),
  ...
)
}
\arguments{
\item{x, object}{the object to be printed}

\item{max_ndoc}{max number of documents to print; default is from the
\verb{print_*_max_ndoc} setting of \code{\link[=quanteda_options]{quanteda_options()}}}

\item{max_nchar}{max number of tokens to print; default is from the
\code{print_corpus_max_nchar} setting of \code{\link[=quanteda_options]{quanteda_options()}}}

\item{show_summary}{print a brief summary indicating the number of documents
and other characteristics of the object, such as docvars or sparsity.}

\item{...}{not used}

\item{max_nfeat}{max number of features to print; default is from the
\code{print_dfm_max_nfeat} setting of \code{\link[=quanteda_options]{quanteda_options()}}}

\item{max_nkey}{max number of keys to print; default is from the
\code{print_dictionary_max_max_nkey} setting of \code{\link[=quanteda_options]{quanteda_options()}}}

\item{max_nval}{max number of values to print; default is from the
\code{print_dictionary_max_nval} setting of \code{\link[=quanteda_options]{quanteda_options()}}}

\item{max_ntoken}{max number of tokens to print; default is from the
\code{print_tokens_max_ntoken} setting of \code{\link[=quanteda_options]{quanteda_options()}}}
}
\description{
Print method for \pkg{quanteda} objects.  In each \verb{max_n*} option, 0 shows none, and
-1 shows all.
}
\examples{
corp <- corpus(data_char_ukimmig2010)
print(corp, max_ndoc = 3, max_nchar = 40)

toks <- tokens(corp)
print(toks, max_ndoc = 3, max_ntoken = 6)

dfmat <- dfm(toks)
print(dfmat, max_ndoc = 3, max_nfeat = 10)
}
\seealso{
\code{\link[=quanteda_options]{quanteda_options()}}
}
\keyword{dfm}
