% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens_subset.R
\name{tokens_subset}
\alias{tokens_subset}
\title{Extract a subset of a tokens}
\usage{
tokens_subset(x, subset, ...)
}
\arguments{
\item{x}{\link{tokens} object to be subsetted}

\item{subset}{logical expression indicating the documents to keep: missing
values are taken as false}

\item{...}{not used}
}
\value{
\link{tokens} object, with a subset of documents (and docvars)
selected according to arguments
}
\description{
Returns document subsets of a tokens that meet certain conditions, including
direct logical operations on docvars (document-level variables).
\code{tokens_subset} functions identically to
\code{\link[=subset.data.frame]{subset.data.frame()}}, using non-standard evaluation to evaluate
conditions based on the \link{docvars} in the tokens.
}
\examples{
corp <- corpus(c(d1 = "a b c d", d2 = "a a b e",
                 d3 = "b b c e", d4 = "e e f a b"),
                 docvars = data.frame(grp = c(1, 1, 2, 3)))
toks <- tokens(corp)
# selecting on a docvars condition
tokens_subset(toks, grp > 1)
# selecting on a supplied vector
tokens_subset(toks, c(TRUE, FALSE, TRUE, FALSE))
}
\seealso{
\code{\link[=subset.data.frame]{subset.data.frame()}}
}
\keyword{tokens}
